/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.hunspell;

enum WordCase {
    UPPER,
    TITLE,
    LOWER,
    MIXED,
    NEUTRAL;


    static WordCase caseOf(char[] word, int length) {
        CharCase startCase = WordCase.charCase(word[0]);
        boolean seenUpper = false;
        boolean seenLower = false;
        for (int i = 1; i < length; ++i) {
            CharCase cc = WordCase.charCase(word[i]);
            seenUpper = seenUpper || cc == CharCase.UPPER;
            boolean bl = seenLower = seenLower || cc == CharCase.LOWER;
            if (seenUpper && seenLower) break;
        }
        return WordCase.get(startCase, seenUpper, seenLower);
    }

    static WordCase caseOf(CharSequence word) {
        return WordCase.caseOf(word, word.length());
    }

    static WordCase caseOf(CharSequence word, int length) {
        CharCase startCase = WordCase.charCase(word.charAt(0));
        boolean seenUpper = false;
        boolean seenLower = false;
        for (int i = 1; i < length; ++i) {
            CharCase cc = WordCase.charCase(word.charAt(i));
            seenUpper = seenUpper || cc == CharCase.UPPER;
            boolean bl = seenLower = seenLower || cc == CharCase.LOWER;
            if (seenUpper && seenLower) break;
        }
        return WordCase.get(startCase, seenUpper, seenLower);
    }

    private static WordCase get(CharCase startCase, boolean seenUpper, boolean seenLower) {
        if (seenLower && seenUpper) {
            return MIXED;
        }
        switch (startCase) {
            case LOWER: {
                return seenUpper ? MIXED : LOWER;
            }
            case UPPER: {
                return !seenLower ? UPPER : TITLE;
            }
        }
        return seenLower ? LOWER : (seenUpper ? UPPER : NEUTRAL);
    }

    private static CharCase charCase(char c) {
        if (Character.isUpperCase(c)) {
            return CharCase.UPPER;
        }
        if (Character.isLowerCase(c) && Character.toUpperCase(c) != c) {
            return CharCase.LOWER;
        }
        return CharCase.NEUTRAL;
    }

    private static enum CharCase {
        UPPER,
        LOWER,
        NEUTRAL;

    }
}

