/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.nl;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArrayMap;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.LowerCaseFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.StopFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.WordlistLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.snowball.SnowballFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.standard.StandardTokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.util.CharsRefBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IOUtils;
import com.dataiku.dss.shadelib.org.tartarus.snowball.ext.DutchStemmer;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class DutchAnalyzer
extends Analyzer {
    public static final String DEFAULT_STOPWORD_FILE = "dutch_stop.txt";
    private final CharArraySet stoptable;
    private final CharArraySet excltable;
    private final StemmerOverrideFilter.StemmerOverrideMap stemdict;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public DutchAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET, CharArraySet.EMPTY_SET, DefaultSetHolder.DEFAULT_STEM_DICT);
    }

    public DutchAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET, DefaultSetHolder.DEFAULT_STEM_DICT);
    }

    public DutchAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionTable) {
        this(stopwords, stemExclusionTable, DefaultSetHolder.DEFAULT_STEM_DICT);
    }

    public DutchAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionTable, CharArrayMap<String> stemOverrideDict) {
        this.stoptable = CharArraySet.unmodifiableSet(CharArraySet.copy(stopwords));
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionTable));
        if (stemOverrideDict.isEmpty()) {
            this.stemdict = null;
        } else {
            StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(false);
            CharArrayMap.EntryIterator iter = stemOverrideDict.entrySet().iterator();
            CharsRefBuilder spare = new CharsRefBuilder();
            while (iter.hasNext()) {
                char[] nextKey = iter.nextKey();
                spare.copyChars(nextKey, 0, nextKey.length);
                builder.add(spare.get(), (CharSequence)iter.currentValue());
            }
            try {
                this.stemdict = builder.build();
            }
            catch (IOException ex) {
                throw new RuntimeException("can not build stem dict", ex);
            }
        }
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stoptable);
        if (!this.excltable.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.excltable);
        }
        if (this.stemdict != null) {
            result = new StemmerOverrideFilter(result, this.stemdict);
        }
        result = new SnowballFilter((TokenStream)result, new DutchStemmer());
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final CharArrayMap<String> DEFAULT_STEM_DICT;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(IOUtils.requireResourceNonNull(SnowballFilter.class.getResourceAsStream(DutchAnalyzer.DEFAULT_STOPWORD_FILE), DutchAnalyzer.DEFAULT_STOPWORD_FILE));
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
            DEFAULT_STEM_DICT = new CharArrayMap(4, false);
            DEFAULT_STEM_DICT.put("fiets", "fiets");
            DEFAULT_STEM_DICT.put("bromfiets", "bromfiets");
            DEFAULT_STEM_DICT.put("ei", "eier");
            DEFAULT_STEM_DICT.put("kind", "kinder");
        }
    }
}

