/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.facet.facetset;

import com.dataiku.dss.shadelib.org.apache.lucene.util.NumericUtils;

public class DimRange {
    public final long min;
    public final long max;

    public DimRange(long min2, long max) {
        this.min = min2;
        this.max = max;
    }

    public static DimRange fromLongs(long min2, boolean minInclusive, long max, boolean maxInclusive) {
        if (!minInclusive) {
            if (min2 != Long.MAX_VALUE) {
                ++min2;
            } else {
                throw new IllegalArgumentException("Invalid min input: " + min2);
            }
        }
        if (!maxInclusive) {
            if (max != Long.MIN_VALUE) {
                --max;
            } else {
                throw new IllegalArgumentException("Invalid max input: " + max);
            }
        }
        if (min2 > max) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum, max=" + max + ", min=" + min2);
        }
        return new DimRange(min2, max);
    }

    public static DimRange fromDoubles(double min2, boolean minInclusive, double max, boolean maxInclusive) {
        if (Double.isNaN(min2)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            min2 = Math.nextUp(min2);
        }
        if (Double.isNaN(max)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            max = Math.nextDown(max);
        }
        if (min2 > max) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum");
        }
        return new DimRange(NumericUtils.doubleToSortableLong(min2), NumericUtils.doubleToSortableLong(max));
    }

    public static DimRange fromFloats(float min2, boolean minInclusive, float max, boolean maxInclusive) {
        if (Float.isNaN(min2)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            min2 = Math.nextUp(min2);
        }
        if (Float.isNaN(max)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            max = Math.nextDown(max);
        }
        if (min2 > max) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum");
        }
        return new DimRange(NumericUtils.floatToSortableInt(min2), NumericUtils.floatToSortableInt(max));
    }
}

