/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.facet.facetset;

import com.dataiku.dss.shadelib.org.apache.lucene.document.FloatPoint;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.facetset.FacetSet;
import com.dataiku.dss.shadelib.org.apache.lucene.util.NumericUtils;
import java.util.stream.IntStream;

public class FloatFacetSet
extends FacetSet {
    public final float[] values;

    public FloatFacetSet(float ... values2) {
        super(FloatFacetSet.validateValuesAndGetNumDims(values2));
        this.values = values2;
    }

    @Override
    public long[] getComparableValues() {
        return IntStream.range(0, this.values.length).mapToLong(idx -> NumericUtils.floatToSortableInt(this.values[idx])).toArray();
    }

    @Override
    public int packValues(byte[] buf, int start) {
        int i = 0;
        int offset = start;
        while (i < this.values.length) {
            FloatPoint.encodeDimension(this.values[i], buf, offset);
            ++i;
            offset += 4;
        }
        return this.values.length * 4;
    }

    @Override
    public int sizePackedBytes() {
        return this.dims * 4;
    }

    private static int validateValuesAndGetNumDims(float ... values2) {
        if (values2 == null || values2.length == 0) {
            throw new IllegalArgumentException("values cannot be null or empty");
        }
        return values2.length;
    }
}

