/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet;

import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.cutters.LongValueFacetCutter;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.iterators.ComparableSupplier;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.recorders.CountFacetRecorder;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.recorders.LongAggregationsFacetRecorder;
import com.dataiku.dss.shadelib.org.apache.lucene.util.InPlaceMergeSorter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public final class ComparableUtils {
    private ComparableUtils() {
    }

    public static ComparableSupplier<ByOrdinalComparable> byOrdinal() {
        return new ComparableSupplier<ByOrdinalComparable>(){

            @Override
            public void reuseComparable(int ord, ByOrdinalComparable reuse) {
                reuse.ord = ord;
            }

            @Override
            public ByOrdinalComparable createComparable(int ord) {
                ByOrdinalComparable result = new ByOrdinalComparable();
                result.ord = ord;
                return result;
            }
        };
    }

    public static ComparableSupplier<ByCountComparable> byCount(final CountFacetRecorder recorder) {
        return new ComparableSupplier<ByCountComparable>(){

            @Override
            public void reuseComparable(int ord, ByCountComparable reuse) {
                reuse.ord = ord;
                reuse.count = recorder.getCount(ord);
            }

            @Override
            public ByCountComparable createComparable(int ord) {
                ByCountComparable result = new ByCountComparable();
                result.ord = ord;
                result.count = recorder.getCount(ord);
                return result;
            }
        };
    }

    public static ComparableSupplier<ByAggregatedValueComparable> byAggregatedValue(final CountFacetRecorder countRecorder, final LongAggregationsFacetRecorder longAggregationsFacetRecorder, final int aggregationId) {
        return new ComparableSupplier<ByAggregatedValueComparable>(){

            @Override
            public void reuseComparable(int ord, ByAggregatedValueComparable reuse) {
                reuse.ord = ord;
                reuse.secondaryRank = countRecorder.getCount(ord);
                reuse.primaryRank = longAggregationsFacetRecorder.getRecordedValue(ord, aggregationId);
            }

            @Override
            public ByAggregatedValueComparable createComparable(int ord) {
                ByAggregatedValueComparable result = new ByAggregatedValueComparable();
                this.reuseComparable(ord, result);
                return result;
            }
        };
    }

    public static ComparableSupplier<ByLongValueComparable> byLongValue(final LongValueFacetCutter longValueFacetCutter) {
        return new ComparableSupplier<ByLongValueComparable>(){

            @Override
            public void reuseComparable(int ord, ByLongValueComparable reuse) {
                reuse.value = longValueFacetCutter.getValue(ord);
            }

            @Override
            public ByLongValueComparable createComparable(int ord) {
                ByLongValueComparable result = new ByLongValueComparable();
                result.value = longValueFacetCutter.getValue(ord);
                return result;
            }
        };
    }

    public static ComparableSupplier<ByCountAndLongValueComparable> byCount(final CountFacetRecorder countFacetRecorder, final LongValueFacetCutter longValueFacetCutter) {
        return new ComparableSupplier<ByCountAndLongValueComparable>(){

            @Override
            public void reuseComparable(int ord, ByCountAndLongValueComparable reuse) {
                reuse.value = longValueFacetCutter.getValue(ord);
                reuse.count = countFacetRecorder.getCount(ord);
            }

            @Override
            public ByCountAndLongValueComparable createComparable(int ord) {
                ByCountAndLongValueComparable result = new ByCountAndLongValueComparable();
                this.reuseComparable(ord, result);
                return result;
            }
        };
    }

    public static <T extends Comparable<T>> void sort(final int[] ordinals, ComparableSupplier<T> comparableSupplier) throws IOException {
        final ArrayList<T> comparables = new ArrayList<T>(ordinals.length);
        for (int i = 0; i < ordinals.length; ++i) {
            comparables.add(comparableSupplier.createComparable(ordinals[i]));
        }
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                int tmp = ordinals[i];
                ordinals[i] = ordinals[j];
                ordinals[j] = tmp;
                Collections.swap(comparables, i, j);
            }

            @Override
            protected int compare(int i, int j) {
                return ((Comparable)comparables.get(j)).compareTo((Comparable)comparables.get(i));
            }
        }.sort(0, ordinals.length);
    }

    public static class ByCountAndLongValueComparable
    implements Comparable<ByCountAndLongValueComparable> {
        private int count;
        private long value;

        private ByCountAndLongValueComparable() {
        }

        @Override
        public int compareTo(ByCountAndLongValueComparable o) {
            int cmp = Integer.compare(this.count, o.count);
            if (cmp == 0) {
                cmp = Long.compare(o.value, this.value);
            }
            return cmp;
        }
    }

    public static final class ByLongValueComparable
    implements Comparable<ByLongValueComparable> {
        private long value;

        private ByLongValueComparable() {
        }

        @Override
        public int compareTo(ByLongValueComparable o) {
            return Long.compare(o.value, this.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ByLongValueComparable) {
                ByLongValueComparable other = (ByLongValueComparable)obj;
                return other.value == this.value;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static class ByAggregatedValueComparable
    implements Comparable<ByAggregatedValueComparable> {
        private int ord;
        private int secondaryRank;
        private long primaryRank;

        private ByAggregatedValueComparable() {
        }

        @Override
        public int compareTo(ByAggregatedValueComparable o) {
            int cmp = Long.compare(this.primaryRank, o.primaryRank);
            if (cmp == 0 && (cmp = Integer.compare(this.secondaryRank, o.secondaryRank)) == 0) {
                cmp = Integer.compare(o.ord, this.ord);
            }
            return cmp;
        }
    }

    public static class ByCountComparable
    implements Comparable<ByCountComparable> {
        private int count;
        private int ord;

        private ByCountComparable() {
        }

        @Override
        public int compareTo(ByCountComparable o) {
            int cmp = Integer.compare(this.count, o.count);
            if (cmp == 0) {
                cmp = Integer.compare(o.ord, this.ord);
            }
            return cmp;
        }
    }

    public static class ByOrdinalComparable
    implements Comparable<ByOrdinalComparable> {
        private int ord;

        @Override
        public int compareTo(ByOrdinalComparable o) {
            return Integer.compare(o.ord, this.ord);
        }
    }
}

