/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.cutters.ranges;

import com.dataiku.dss.shadelib.org.apache.lucene.facet.MultiDoubleValuesSource;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.MultiLongValuesSource;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.range.DoubleRange;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.range.LongRange;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.cutters.FacetCutter;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.cutters.LeafFacetCutter;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.cutters.ranges.LongRangeFacetCutter;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DoubleValuesSource;
import com.dataiku.dss.shadelib.org.apache.lucene.search.LongValuesSource;
import com.dataiku.dss.shadelib.org.apache.lucene.util.NumericUtils;
import java.io.IOException;

public final class DoubleRangeFacetCutter
implements FacetCutter {
    private final LongRangeFacetCutter longRangeFacetCutter;

    public DoubleRangeFacetCutter(MultiDoubleValuesSource multiDoubleValuesSource, DoubleRange[] doubleRanges) {
        MultiLongValuesSource multiLongValuesSource;
        LongValuesSource singleLongValuesSource;
        DoubleValuesSource singleDoubleValuesSource = MultiDoubleValuesSource.unwrapSingleton(multiDoubleValuesSource);
        if (singleDoubleValuesSource != null) {
            singleLongValuesSource = singleDoubleValuesSource.toSortableLongDoubleValuesSource();
            multiLongValuesSource = null;
        } else {
            singleLongValuesSource = null;
            multiLongValuesSource = multiDoubleValuesSource.toSortableMultiLongValuesSource();
        }
        LongRange[] longRanges = this.mapDoubleRangesToSortableLong(doubleRanges);
        this.longRangeFacetCutter = LongRangeFacetCutter.createSingleOrMultiValued(multiLongValuesSource, singleLongValuesSource, longRanges);
    }

    @Override
    public LeafFacetCutter createLeafCutter(LeafReaderContext context) throws IOException {
        return this.longRangeFacetCutter.createLeafCutter(context);
    }

    private LongRange[] mapDoubleRangesToSortableLong(DoubleRange[] doubleRanges) {
        LongRange[] longRanges = new LongRange[doubleRanges.length];
        for (int i = 0; i < longRanges.length; ++i) {
            DoubleRange dr = doubleRanges[i];
            longRanges[i] = new LongRange(dr.label, NumericUtils.doubleToSortableLong(dr.min), true, NumericUtils.doubleToSortableLong(dr.max), true);
        }
        return longRanges;
    }
}

