/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BulkScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Explanation;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchAllDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Matches;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScorerSupplier;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import java.io.IOException;

public final class IndexOrDocValuesQuery
extends Query {
    private final Query indexQuery;
    private final Query dvQuery;

    public IndexOrDocValuesQuery(Query indexQuery, Query dvQuery) {
        this.indexQuery = indexQuery;
        this.dvQuery = dvQuery;
    }

    public Query getIndexQuery() {
        return this.indexQuery;
    }

    public Query getRandomAccessQuery() {
        return this.dvQuery;
    }

    @Override
    public String toString(String field) {
        return "IndexOrDocValuesQuery(indexQuery=" + this.indexQuery.toString(field) + ", dvQuery=" + this.dvQuery.toString(field) + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        IndexOrDocValuesQuery that = (IndexOrDocValuesQuery)obj;
        return this.indexQuery.equals(that.indexQuery) && this.dvQuery.equals(that.dvQuery);
    }

    @Override
    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + this.indexQuery.hashCode();
        h2 = 31 * h2 + this.dvQuery.hashCode();
        return h2;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query indexRewrite = this.indexQuery.rewrite(indexSearcher);
        Query dvRewrite = this.dvQuery.rewrite(indexSearcher);
        if (indexRewrite.getClass() == MatchAllDocsQuery.class || dvRewrite.getClass() == MatchAllDocsQuery.class) {
            return new MatchAllDocsQuery();
        }
        if (this.indexQuery != indexRewrite || this.dvQuery != dvRewrite) {
            return new IndexOrDocValuesQuery(indexRewrite, dvRewrite);
        }
        return this;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, this);
        this.indexQuery.visit(v);
        this.dvQuery.visit(v);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight indexWeight = this.indexQuery.createWeight(searcher, scoreMode, boost);
        final Weight dvWeight = this.dvQuery.createWeight(searcher, scoreMode, boost);
        return new Weight(this){

            @Override
            public Matches matches(LeafReaderContext context, int doc) throws IOException {
                return dvWeight.matches(context, doc);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return dvWeight.explain(context, doc);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                return indexWeight.bulkScorer(context);
            }

            @Override
            public int count(LeafReaderContext context) throws IOException {
                int count = indexWeight.count(context);
                if (count != -1) {
                    return count;
                }
                return dvWeight.count(context);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final ScorerSupplier indexScorerSupplier = indexWeight.scorerSupplier(context);
                final ScorerSupplier dvScorerSupplier = dvWeight.scorerSupplier(context);
                if (indexScorerSupplier == null || dvScorerSupplier == null) {
                    return null;
                }
                return new ScorerSupplier(){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        long threshold = this.cost() >>> 3;
                        if (threshold <= leadCost) {
                            return indexScorerSupplier.get(leadCost);
                        }
                        return dvScorerSupplier.get(leadCost);
                    }

                    @Override
                    public long cost() {
                        return indexScorerSupplier.cost();
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return indexWeight.isCacheable(ctx);
            }
        };
    }
}

