/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util.hnsw;

import com.dataiku.dss.shadelib.org.apache.lucene.codecs.hnsw.HnswGraphProvider;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TaskExecutor;
import com.dataiku.dss.shadelib.org.apache.lucene.util.FixedBitSet;
import com.dataiku.dss.shadelib.org.apache.lucene.util.hnsw.HnswBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.util.hnsw.HnswConcurrentMergeBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.util.hnsw.HnswGraph;
import com.dataiku.dss.shadelib.org.apache.lucene.util.hnsw.IncrementalHnswGraphMerger;
import com.dataiku.dss.shadelib.org.apache.lucene.util.hnsw.InitializedHnswGraphBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import com.dataiku.dss.shadelib.org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import java.io.IOException;

public class ConcurrentHnswMerger
extends IncrementalHnswGraphMerger {
    private final TaskExecutor taskExecutor;
    private final int numWorker;

    public ConcurrentHnswMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, TaskExecutor taskExecutor, int numWorker) {
        super(fieldInfo, scorerSupplier, M, beamWidth);
        this.taskExecutor = taskExecutor;
        this.numWorker = numWorker;
    }

    @Override
    protected HnswBuilder createBuilder(DocIdSetIterator mergedVectorIterator, int maxOrd) throws IOException {
        if (this.initReader == null) {
            return new HnswConcurrentMergeBuilder(this.taskExecutor, this.numWorker, this.scorerSupplier, this.M, this.beamWidth, new OnHeapHnswGraph(this.M, maxOrd), null);
        }
        HnswGraph initializerGraph = ((HnswGraphProvider)((Object)this.initReader)).getGraph(this.fieldInfo.name);
        FixedBitSet initializedNodes = new FixedBitSet(maxOrd);
        int[] oldToNewOrdinalMap = this.getNewOrdMapping(mergedVectorIterator, initializedNodes);
        return new HnswConcurrentMergeBuilder(this.taskExecutor, this.numWorker, this.scorerSupplier, this.M, this.beamWidth, InitializedHnswGraphBuilder.initGraph(this.M, initializerGraph, oldToNewOrdinalMap, maxOrd), initializedNodes);
    }
}

