/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.CreateQueryRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.GetQueryRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.ListQueriesRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.ListQueryObjectsResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.ListQueryObjectsResponseQuery;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.ListVisualizationsForQueryRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.ListVisualizationsForQueryResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.QueriesImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.QueriesService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.Query;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.TrashQueryRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.UpdateQueryRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.sql.Visualization;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class QueriesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(QueriesAPI.class);
    private final QueriesService impl;

    public QueriesAPI(ApiClient apiClient) {
        this.impl = new QueriesImpl(apiClient);
    }

    public QueriesAPI(QueriesService mock) {
        this.impl = mock;
    }

    public Query create(CreateQueryRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new TrashQueryRequest().setId(id));
    }

    public void delete(TrashQueryRequest request) {
        this.impl.delete(request);
    }

    public Query get(String id) {
        return this.get(new GetQueryRequest().setId(id));
    }

    public Query get(GetQueryRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ListQueryObjectsResponseQuery> list(ListQueriesRequest request) {
        return new Paginator(request, this.impl::list, ListQueryObjectsResponse::getResults, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Visualization> listVisualizations(String id) {
        return this.listVisualizations(new ListVisualizationsForQueryRequest().setId(id));
    }

    public Iterable<Visualization> listVisualizations(ListVisualizationsForQueryRequest request) {
        return new Paginator(request, this.impl::listVisualizations, ListVisualizationsForQueryResponse::getResults, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Query update(String id, String updateMask) {
        return this.update(new UpdateQueryRequest().setId(id).setUpdateMask(updateMask));
    }

    public Query update(UpdateQueryRequest request) {
        return this.impl.update(request);
    }

    public QueriesService impl() {
        return this.impl;
    }
}

