/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2;

import com.dataiku.dss.shadelibdatabricks.com.google.api.client.http.GenericUrl;
import com.dataiku.dss.shadelibdatabricks.com.google.api.client.http.HttpHeaders;
import com.dataiku.dss.shadelibdatabricks.com.google.api.client.http.HttpRequest;
import com.dataiku.dss.shadelibdatabricks.com.google.api.client.http.HttpResponse;
import com.dataiku.dss.shadelibdatabricks.com.google.api.client.json.GenericJson;
import com.dataiku.dss.shadelibdatabricks.com.google.api.client.json.JsonObjectParser;
import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.AccessToken;
import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.ExternalAccountCredentials;
import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.IdentityPoolCredentialSource;
import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.OAuth2Utils;
import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.StsTokenExchangeRequest;
import com.dataiku.dss.shadelibdatabricks.com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class IdentityPoolCredentials
extends ExternalAccountCredentials {
    private static final long serialVersionUID = 2471046175477275881L;
    private final IdentityPoolCredentialSource identityPoolCredentialSource;

    IdentityPoolCredentials(Builder builder) {
        super(builder);
        this.identityPoolCredentialSource = (IdentityPoolCredentialSource)builder.credentialSource;
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        String credential = this.retrieveSubjectToken();
        StsTokenExchangeRequest.Builder stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder(credential, this.getSubjectTokenType()).setAudience(this.getAudience());
        Collection<String> scopes = this.getScopes();
        if (scopes != null && !scopes.isEmpty()) {
            stsTokenExchangeRequest.setScopes(new ArrayList<String>(scopes));
        }
        return this.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest.build());
    }

    @Override
    public String retrieveSubjectToken() throws IOException {
        if (this.identityPoolCredentialSource.credentialSourceType == IdentityPoolCredentialSource.IdentityPoolCredentialSourceType.FILE) {
            return this.retrieveSubjectTokenFromCredentialFile();
        }
        return this.getSubjectTokenFromMetadataServer();
    }

    @Override
    String getCredentialSourceType() {
        if (((IdentityPoolCredentialSource)this.getCredentialSource()).credentialSourceType == IdentityPoolCredentialSource.IdentityPoolCredentialSourceType.FILE) {
            return "file";
        }
        return "url";
    }

    private String retrieveSubjectTokenFromCredentialFile() throws IOException {
        String credentialFilePath = this.identityPoolCredentialSource.credentialLocation;
        if (!Files.exists(Paths.get(credentialFilePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new IOException(String.format("Invalid credential location. The file at %s does not exist.", credentialFilePath));
        }
        try {
            return this.parseToken(new FileInputStream(new File(credentialFilePath)));
        }
        catch (IOException e) {
            throw new IOException("Error when attempting to read the subject token from the credential file.", e);
        }
    }

    private String parseToken(InputStream inputStream) throws IOException {
        if (this.identityPoolCredentialSource.credentialFormatType == IdentityPoolCredentialSource.CredentialFormatType.TEXT) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return CharStreams.toString(reader);
        }
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        GenericJson fileContents = parser.parseAndClose(inputStream, StandardCharsets.UTF_8, GenericJson.class);
        if (!fileContents.containsKey(this.identityPoolCredentialSource.subjectTokenFieldName)) {
            throw new IOException("Invalid subject token field name. No subject token was found.");
        }
        return (String)fileContents.get(this.identityPoolCredentialSource.subjectTokenFieldName);
    }

    private String getSubjectTokenFromMetadataServer() throws IOException {
        HttpRequest request = this.transportFactory.create().createRequestFactory().buildGetRequest(new GenericUrl(this.identityPoolCredentialSource.credentialLocation));
        request.setParser(new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        if (this.identityPoolCredentialSource.hasHeaders()) {
            HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map<? extends String, ?>)this.identityPoolCredentialSource.headers);
            request.setHeaders(headers);
        }
        try {
            HttpResponse response = request.execute();
            return this.parseToken(response.getContent());
        }
        catch (IOException e) {
            throw new IOException(String.format("Error getting subject token from metadata server: %s", e.getMessage()), e);
        }
    }

    @Override
    public IdentityPoolCredentials createScoped(Collection<String> newScopes) {
        return new IdentityPoolCredentials((Builder)IdentityPoolCredentials.newBuilder(this).setScopes(newScopes));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(IdentityPoolCredentials identityPoolCredentials) {
        return new Builder(identityPoolCredentials);
    }

    public static class Builder
    extends ExternalAccountCredentials.Builder {
        Builder() {
        }

        Builder(IdentityPoolCredentials credentials) {
            super(credentials);
        }

        @Override
        public Builder setWorkforcePoolUserProject(String workforcePoolUserProject) {
            super.setWorkforcePoolUserProject(workforcePoolUserProject);
            return this;
        }

        @Override
        public IdentityPoolCredentials build() {
            return new IdentityPoolCredentials(this);
        }
    }
}

