/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.MimeTypesSecurity;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.Wiki;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/wiki"})
public class PublicAPIWikisController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private WikisService wikisService;

    @AuditedCall(value={"msgType", "wiki-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        Wiki wiki;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            wiki = this.wikisService.getWikiUnsafe(projectKey);
        }
        PublicAPIWikisController.writeJSON((HttpServletResponse)resp, (Object)wiki);
    }

    @AuditedCall(value={"msgType", "wiki-set", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.PUT})
    public void set(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        Wiki ret;
        Wiki wiki = (Wiki)this.getRequestBodyAs(req, Wiki.class);
        this.require(wiki.projectKey != null, "Required field 'projectKey' is missing.");
        this.require(wiki.projectKey.equals(projectKey), "Wiki projectKey does not match the requested URL");
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.wikisService.setWiki(wiki);
            ret = this.wikisService.getWikiUnsafe(projectKey);
            t.commit("Updated wiki for project " + projectKey);
        }
        PublicAPIWikisController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "article-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void createArticle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        ArticleCreationInfo articleCreationInfo = (ArticleCreationInfo)this.getRequestBodyAs(req, ArticleCreationInfo.class);
        this.require(articleCreationInfo.projectKey != null, "Required field 'projectKey' is missing.");
        this.require(articleCreationInfo.name != null, "Required field 'name' is missing.");
        this.require(articleCreationInfo.projectKey.equals(projectKey), "Article projectKey does not match the requested URL");
        ArticleAndPayload ret = new ArticleAndPayload();
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            ret.article = this.wikisService.createArticle(articleCreationInfo.projectKey, articleCreationInfo.name, articleCreationInfo.parent, null);
            ret.payload = this.wikisService.getArticlePayloadOrNull(articleCreationInfo.projectKey, ret.article.id);
            t.commitV("Created article %s (%s)", new Object[]{ret.article.getFullId(), ret.article.getDisplayName()});
        }
        PublicAPIWikisController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "article-get", "projectKey", "${projectKey}", "articleId", "${articleId}"})
    @RequestMapping(value={"/{articleId:.+}"}, method={RequestMethod.GET})
    public void getArticle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String articleId) throws Exception {
        ArticleAndPayload articleAndPayload = new ArticleAndPayload();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            articleAndPayload.article = this.wikisService.getSmartArticleMandatoryUnsafe(projectKey, articleId);
            articleAndPayload.payload = this.wikisService.getArticlePayloadOrNull(projectKey, articleAndPayload.article.id);
        }
        PublicAPIWikisController.writeJSON((HttpServletResponse)resp, (Object)articleAndPayload);
    }

    @AuditedCall(value={"msgType", "article-set", "projectKey", "${projectKey}", "articleId", "${articleId}"})
    @RequestMapping(value={"/{articleId:.+}"}, method={RequestMethod.PUT})
    public void setArticle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String articleId, @RequestBody ArticleAndPayload articleAndPayload) throws Exception {
        this.require(articleAndPayload.article != null, "Required field 'article' is missing.");
        this.require(StringUtils.isNotBlank((String)articleAndPayload.article.projectKey), "Required field 'article.projectKey' is missing.");
        this.require(StringUtils.isNotBlank((String)articleAndPayload.article.id), "Required field 'article.id' is missing.");
        this.require(articleAndPayload.article.projectKey.equals(projectKey), "Article projectKey does not match the requested URL");
        this.require(articleAndPayload.article.id.equals(articleId), "Article id does not match the requested URL (renaming forbidden)");
        ArticleAndPayload ret = new ArticleAndPayload();
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            if (this.wikisService.getArticleOrNullUnsafe(projectKey, articleId) == null) {
                this.wikisService.createArticle(projectKey, articleId, null, null);
            }
            this.wikisService.saveArticle(articleAndPayload.article, articleAndPayload.payload);
            ret.article = this.wikisService.getSmartArticleMandatoryUnsafe(projectKey, articleId);
            ret.payload = this.wikisService.getArticlePayloadOrNull(projectKey, ret.article.id);
            t.commitV("Updated article %s (%s)", new Object[]{ret.article.getFullId(), ret.article.getDisplayName()});
        }
        PublicAPIWikisController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "article-upload", "projectKey", "${projectKey}", "articleId", "${articleId}"})
    @RequestMapping(value={"/{articleId:.+}/upload"}, method={RequestMethod.POST})
    public void upload(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String articleId, @RequestParam MultipartFile file) throws Exception {
        Article article;
        Callable callableUploadHandler;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            callableUploadHandler = this.wikisService.handleUploadRequest(projectKey, file.getInputStream(), file.getOriginalFilename(), authCtx);
        }
        this.wikisService.checkNewUploadedAttachmentFileExtension(file.getOriginalFilename());
        Article.ArticleAttachment att = (Article.ArticleAttachment)callableUploadHandler.call();
        this.wikisService.saveUploadMeta(projectKey, att, file.getOriginalFilename(), authCtx);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            article = this.wikisService.getArticleMandatory(projectKey, articleId);
            article.attachments.add(att);
            this.wikisService.saveArticle(article, null);
            t.commit("Uploaded file to article " + article.getFullId());
        }
        PublicAPIWikisController.writeJSON((HttpServletResponse)resp, (Object)article);
    }

    @AuditedCall(value={"msgType", "article-upload-get", "projectKey", "${projectKey}", "articleId", "${articleId}", "uploadId", "${uploadId}"})
    @RequestMapping(value={"/{articleId:.+}/uploads/{uploadId:.+}"}, method={RequestMethod.GET})
    public void getUploadedFile(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String articleId, @PathVariable String uploadId) throws Exception {
        WikisService.UploadMeta meta;
        File file;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            if (projectKey != null) {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS});
            }
            file = this.wikisService.getUploadedFile(projectKey, uploadId);
            meta = this.wikisService.getUploadMeta(projectKey, uploadId);
        }
        resp.setDateHeader("Last-Modified", file.lastModified());
        resp.setContentType(meta.mimeType);
        if (!MimeTypesSecurity.isSafeForInlineContentDisposition((String)meta.mimeType)) {
            resp.setHeader("Content-Disposition", "attachment");
        }
        resp.addDateHeader("Expires", System.currentTimeMillis() + 60000L);
        long ifModifiedSince = req.getDateHeader("If-Modified-Since");
        if (file.lastModified() <= ifModifiedSince) {
            resp.setStatus(304);
        } else {
            try (FileInputStream inputStream = new FileInputStream(file);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)resp.getOutputStream());
            }
        }
    }

    @AuditedCall(value={"msgType", "article-delete", "projectKey", "${projectKey}", "articleId", "${articleId}"})
    @RequestMapping(value={"/{articleId:.+}"}, method={RequestMethod.DELETE})
    public void deleteArticle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String articleId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.wikisService.deleteArticle(projectKey, articleId, false);
            t.commit("Deleted article " + projectKey + "." + articleId);
        }
        this.writeMessage(resp, "Deleted article %s.%s", new Object[]{projectKey, articleId});
    }

    public static class ArticleCreationInfo {
        public String projectKey;
        public String name;
        public String parent;
    }

    public static class ArticleAndPayload {
        public Article article;
        public String payload;
    }
}

