/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.projects;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.projects.importexport.model.ProjectDuplicateOptions;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.ProjectImportExportController;
import com.dataiku.dip.server.controllers.admin.AdminEditionController;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.GitReferencesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.GitCodes;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.cli.GitRemoteCommands;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.HandlerMapping;

@Controller
@RequestMapping(value={"/publicapi/projects"})
public class PublicAPIProjectsGitController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsJGitService projectsGitService;
    @Autowired
    private GitReferencesService gitRefsService;
    @Autowired
    private ProjectImportExportController internalController;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectFoldersService projectFoldersService;

    @AuditedCall(value={"msgType", "project-git-list-remote-repositories", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/remotes"}, method={RequestMethod.GET})
    public void listRemotes(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        RemoteGitPermission remoteGitPermission = this.checkUseRemoteGitPermission(req, projectKey);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, this.listRemotes(projectKey, remoteGitPermission.useRemoteGit, remoteGitPermission.authCtx));
    }

    @AuditedCall(value={"msgType", "project-git-get-remote-repository", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/remotes/{remoteName}"}, method={RequestMethod.GET})
    public void getRemote(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String remoteName) throws Exception {
        RemoteGitPermission remoteGitPermission = this.checkUseRemoteGitPermission(req, projectKey);
        GitModel.GitRemote response = this.listRemotes(projectKey, remoteGitPermission.useRemoteGit, remoteGitPermission.authCtx).stream().filter(r -> r.name.equals(remoteName)).findAny().orElse(new GitModel.GitRemote());
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)response);
    }

    @AuditedCall(value={"msgType", "project-git-set-remote-repository", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/remotes/{remoteName}"}, method={RequestMethod.POST})
    public void setRemote(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String remoteName, @RequestBody GitModel.GitRemote body) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)body.url), (Object)"remoteUrl cannot be null or empty");
        this.setOrRemoveRemote_NT(req, resp, projectKey, remoteName, body.url);
    }

    @AuditedCall(value={"msgType", "project-git-remove-remote-repository", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/remotes/{remoteName}"}, method={RequestMethod.DELETE})
    public void removeRemote(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String remoteName) throws Exception {
        this.setOrRemoveRemote_NT(req, resp, projectKey, remoteName, null);
    }

    @AuditedCall(value={"msgType", "project-git-list-branches", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/branches"}, method={RequestMethod.GET})
    public void listBranches(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(required=false, defaultValue="false") boolean remote) throws Exception {
        this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        GitModel.GitBranches branches = this.projectsGitService.listBranches_NT(projectKey);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)(remote ? branches.remote : branches.local));
    }

    @AuditedCall(value={"msgType", "project-git-get-current-branch", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/current-branch"}, method={RequestMethod.GET})
    public void getCurrentBranch(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        GitBranch response = new GitBranch();
        response.name = this.projectsGitService.getFullStatus_NT((String)projectKey, (AuthCtx)authCtx).currentBranch;
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)response);
    }

    @AuditedCall(value={"msgType", "project-git-get-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/status"}, method={RequestMethod.GET})
    public void getStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        GitModel.GitFullStatus fullStatus = this.projectsGitService.getFullStatus_NT(projectKey, authCtx);
        GitModel.GitWorkingTreeStatus workingCopyStatus = this.projectsGitService.getWorkingCopyStatus_NT(projectKey);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)new GitStatus(fullStatus, workingCopyStatus));
    }

    @AuditedCall(value={"msgType", "project-git-switch-branch", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/actions/switchBranch"}, method={RequestMethod.POST})
    public void switchBranch(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String branchName) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        if (PublicAPIProjectsGitController.isInvalidRefName(branchName)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid branch name", branchName));
        }
        DKUtils.SmartLogTailBuilder logBuilder = new DKUtils.SmartLogTailBuilder();
        GitRemoteCommands.GitCommandResult gitCommandResult = this.projectsGitService.checkoutBranch_NT(authCtx, projectKey, branchName, logBuilder);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)new GitActionResult(gitCommandResult, logBuilder));
    }

    @AuditedCall(value={"msgType", "project-git-create-branch", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/branches/"}, method={RequestMethod.POST})
    public void createBranch(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody CreateBranchRequest createGitBranchRequest) throws Exception {
        if (PublicAPIProjectsGitController.isInvalidRefName(createGitBranchRequest.name)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid branch name", createGitBranchRequest.name));
        }
        DSSAuthCtx authCtx = (DSSAuthCtx)this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        CreateBranchResult result = createGitBranchRequest.duplicateProject ? this.createDuplicatedProjectWithBranch(projectKey, createGitBranchRequest, authCtx) : this.createGitBranch(projectKey, createGitBranchRequest, authCtx);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    public CreateBranchResult createGitBranch(String projectKey, CreateBranchRequest request, DSSAuthCtx authCtx) throws GitAPIException, IOException, CodedException, LimitsStatusComputer.LicenseLimitException {
        Set existingBranches = this.projectsGitService.listAvailableBranches_NT(projectKey, true);
        if (existingBranches.contains(request.name)) {
            throw new CodedException((InfoMessage.MessageCode)GitCodes.ERR_GIT_BRANCH_CREATION_FAILED, String.format("Cannot create branch. A branch named '%s' already exists", request.name));
        }
        CreateBranchResult result = new CreateBranchResult();
        result.output = this.projectsGitService.createBranch_NT((AuthCtx)authCtx, projectKey, projectKey, request.name, request.commit);
        result.success = true;
        return result;
    }

    public CreateBranchResult createDuplicatedProjectWithBranch(String projectKey, CreateBranchRequest request, DSSAuthCtx authCtx) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            this.permissionsService.checkCanExportAndManageBundles((AuthCtx)authCtx, projectKey);
            if (authCtx.getAuthSource() == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_PROJECT || !authCtx.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
            this.assignOrValidateTargetProjectKey(projectKey, request);
            String folderId = this.projectFoldersService.getProjectFolderIdOrRoot(request.targetProjectFolderId);
            this.permissionsService.checkProjectFolderPrivilege((AuthCtx)authCtx, folderId, new Privileges.ProjectFolderLevelPrivilegeType[]{Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS});
        }
        ProjectDuplicateOptions options = new ProjectDuplicateOptions();
        options.exportUploads = true;
        options.exportGitRepository = true;
        options.targetProjectKey = request.targetProjectKey;
        options.createBranch = true;
        options.targetProjectName = projectKey + " (" + request.name + ")";
        options.targetBranchName = request.name;
        options.targetProjectFolderId = request.targetProjectFolderId;
        FutureProgress.init();
        try (FutureProgress.AutocloseableFutureProgressState fps = FutureProgress.pushAutoCloseableState((String)"Duplicating");){
            String duplicationId = SecretKeyGenerator.generate((int)16);
            ProjectImportExportController.ProjectDuplicateResult duplicateResult = this.internalController.processDuplicate(projectKey, (AuthCtx)authCtx, duplicationId, options);
            CreateBranchResult result = new CreateBranchResult();
            result.success = duplicateResult.success;
            result.targetProjectKey = request.targetProjectKey;
            result.output = duplicateResult.messages.stream().map(m -> "[" + String.valueOf(m.severity) + "]" + m.code + ": " + m.message).collect(Collectors.joining("\n"));
            CreateBranchResult createBranchResult = result;
            return createBranchResult;
        }
    }

    private String generateUniqueProjectKey(String baseKey, String suffix) throws IOException {
        String candidate = baseKey + "_" + suffix;
        int count = 1;
        while (this.projectsService.getOrNullUnsafe(candidate) != null) {
            candidate = baseKey + "_" + suffix + "_" + count++;
        }
        return candidate;
    }

    private void assignOrValidateTargetProjectKey(String baseProjectKey, CreateBranchRequest request) throws IOException {
        if (StringUtils.isBlank((String)request.targetProjectKey)) {
            request.targetProjectKey = this.generateUniqueProjectKey(baseProjectKey, request.name.toUpperCase());
        } else if (this.projectsService.getOrNullUnsafe(request.targetProjectKey) != null) {
            throw new DKUControllerBase.MalformedRequestException("Project " + request.targetProjectKey + " already exists");
        }
    }

    @AuditedCall(value={"msgType", "project-git-delete-branch", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/actions/deleteBranch"}, method={RequestMethod.POST})
    public void deleteBranch(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody DeleteBranchRequest deleteGitBranchRequest) throws Exception {
        String branchName = deleteGitBranchRequest.name;
        if (PublicAPIProjectsGitController.isInvalidRefName(branchName)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid branch name", branchName));
        }
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        if (deleteGitBranchRequest.remote) {
            this.projectsGitService.deleteRemoteBranch_NT(authCtx, projectKey, branchName, deleteGitBranchRequest.forceDelete, deleteGitBranchRequest.deleteRemotely, "origin");
        } else {
            this.projectsGitService.deleteLocalBranch_NT(projectKey, branchName, deleteGitBranchRequest.forceDelete);
        }
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "project-git-fetch", "projectKey", "${projectKey}", "remoteName", "origin"})
    @RequestMapping(value={"/{projectKey}/git/actions/fetch"}, method={RequestMethod.POST})
    public void fetch(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        DKUtils.SmartLogTailBuilder logBuilder = new DKUtils.SmartLogTailBuilder();
        GitRemoteCommands.GitCommandResult gitCommandResult = this.projectsGitService.fetch_NT(projectKey, "origin", authCtx, logBuilder);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)new GitActionResult(gitCommandResult, logBuilder));
    }

    @AuditedCall(value={"msgType", "project-git-pull", "projectKey", "${projectKey}", "remoteName", "origin"})
    @RequestMapping(value={"/{projectKey}/git/actions/pullRebase"}, method={RequestMethod.POST})
    public void pull(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(required=false, defaultValue="origin") String remoteName, @RequestParam(required=false) String branchName) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        if (StringUtils.isBlank((String)branchName)) {
            branchName = this.projectsGitService.getCurrentBranch_NT(projectKey);
        }
        DKUtils.SmartLogTailBuilder logBuilder = new DKUtils.SmartLogTailBuilder();
        GitRemoteCommands.GitCommandResult gitCommandResult = this.projectsGitService.pullRebase_NT(projectKey, remoteName, branchName, authCtx, logBuilder);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)new GitActionResult(gitCommandResult, logBuilder));
    }

    @AuditedCall(value={"msgType", "project-git-push", "projectKey", "${projectKey}", "remoteName", "origin"})
    @RequestMapping(value={"/{projectKey}/git/actions/push"}, method={RequestMethod.POST})
    public void push(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(required=false, defaultValue="origin") String remoteName, @RequestParam(required=false, defaultValue="") String branchName) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        DKUtils.SmartLogTailBuilder logBuilder = new DKUtils.SmartLogTailBuilder();
        GitRemoteCommands.GitCommandResult gitCommandResult = this.projectsGitService.push_NT(authCtx, projectKey, remoteName, branchName, logBuilder);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)new GitActionResult(gitCommandResult, logBuilder));
    }

    @AuditedCall(value={"msgType", "project-git-reset-to-upstream", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/actions/resetToRemoteHeadState"}, method={RequestMethod.POST})
    public void resetToRemoteHeadState(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        this.projectsGitService.resetToUpstream_NT(authCtx, projectKey, "", "");
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "project-git-reset-to-head", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/actions/resetToLocalHeadState"}, method={RequestMethod.POST})
    public void resetToLocalHeadState(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        this.projectsGitService.resetToHead_NT(authCtx, projectKey);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "object-commit", "projectKey", "${projectKey}", "objectType", "PROJECT", "objectId", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/actions/commit"}, method={RequestMethod.POST})
    public void commit(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody CommitRequest body) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        TaggableObjectsService.TaggableObjectRef tor = PublicAPIProjectsGitController.objectRef(projectKey);
        this.projectsGitService.commitObject(tor, authCtx, body.message);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "object-get-log", "projectKey", "${projectKey}", "objectType", "PROJECT", "objectId", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/actions/log"}, method={RequestMethod.GET})
    public void getLog(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(required=false) String path, @RequestParam(required=false) String startCommit, @RequestParam(required=false, defaultValue="1000") int count) throws Exception {
        this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        GitLog response = new GitLog();
        DSSGitModel.ObjectLog objectLogSince = this.projectsGitService.getObjectLog(PublicAPIProjectsGitController.objectRef(projectKey), startCommit, count, path);
        response.nextCommit = objectLogSince.nextCommit;
        response.entries = objectLogSince.logEntries == null ? new ArrayList<GitLogEntry>() : objectLogSince.logEntries.stream().map(GitLogEntry::new).collect(Collectors.toList());
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)response);
    }

    @AuditedCall(value={"msgType", "project-get-diff", "projectKey", "${projectKey}", "commitFrom", "${commitFrom}", "commitTo", "${commitTo}"})
    @RequestMapping(value={"/{projectKey}/git/actions/diff"}, method={RequestMethod.GET})
    public void getDiff(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(required=false) String commitFrom, @RequestParam(required=false) String commitTo) throws Exception {
        GitDiff response;
        this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        if (StringUtils.isBlank((String)commitFrom)) {
            if (StringUtils.isNotBlank((String)commitTo)) {
                throw new IllegalArgumentException("Missing from 'from' parameter. If 'to' is supplied, 'from' must be supplied too.");
            }
            response = new GitDiff(this.projectsGitService.prepareObjectCommit(PublicAPIProjectsGitController.objectRef(projectKey)));
        } else if (StringUtils.isBlank((String)commitTo)) {
            GitModel.SingleCommitObjectDiff commitDiff = this.projectsGitService.getSingleCommitDiff(projectKey, commitFrom);
            response = new GitDiff(commitDiff);
        } else {
            response = new GitDiff(this.projectsGitService.getObjectDiff(PublicAPIProjectsGitController.objectRef(projectKey), commitFrom, commitTo));
        }
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)response);
    }

    @AuditedCall(value={"msgType", "project-get-list-tags", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/tags"}, method={RequestMethod.GET})
    public void listTags(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        Set tags = this.projectsGitService.getLocalTags_NT(projectKey);
        List response = tags != null ? tags.stream().map(tag -> new GitTag((GitModel.GitTag)tag, true)).collect(Collectors.toList()) : Collections.emptyList();
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, response);
    }

    @AuditedCall(value={"msgType", "add-git-tag", "projectKey", "${projectKey}", "objectType", "PROJECT", "objectId", "${projectKey}", "name", "${name}"})
    @RequestMapping(value={"/{projectKey}/git/tags/"}, method={RequestMethod.POST})
    public void createTag(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody CreateTagRequest body) throws Exception {
        if (PublicAPIProjectsGitController.isInvalidRefName(body.name)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid tag name", body.name));
        }
        if (GitModel.GitTag.isReadOnly((String)body.name)) {
            throw new DKUSecurityException("You can't add a tag beginning with 'dss-'");
        }
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        this.projectsGitService.addProjectTag_NT(authCtx, projectKey, body.name, body.message, body.reference);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "remove-git-tag", "projectKey", "${projectKey}", "objectType", "PROJECT", "objectId", "${projectKey}", "name", "${name}"})
    @RequestMapping(value={"/{projectKey}/git/actions/deleteTag"}, method={RequestMethod.POST})
    public void deleteTag(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody DeleteTagRequest deleteGitTagRequest) throws Exception {
        String name = deleteGitTagRequest.name;
        if (PublicAPIProjectsGitController.isInvalidRefName(name)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid tag name", name));
        }
        if (GitModel.GitTag.isReadOnly((String)name)) {
            throw new DKUSecurityException("You can't remove a tag beginning with 'dss-'");
        }
        this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        this.projectsGitService.removeProjectTag_NT(projectKey, name);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "object-revert", "projectKey", "${projectKey}", "objectType", "PROJECT", "objectId", "${projectKey}", "toRevision", "${commit}"})
    @RequestMapping(value={"/{projectKey}/git/actions/revertToRevision"}, method={RequestMethod.POST})
    public void revertToRevision(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String commit) throws Exception {
        if (StringUtils.isBlank((String)commit)) {
            throw new IllegalArgumentException("Missing 'commit' request parameter");
        }
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        this.writeGitRevertResponse(resp, this.projectsGitService.revertProjectToRevision(authCtx, projectKey, commit));
    }

    @AuditedCall(value={"msgType", "object-revert", "projectKey", "${projectKey}", "objectType", "PROJECT", "objectId", "${projectKey}", "commitId", "${commit}"})
    @RequestMapping(value={"/{projectKey}/git/actions/revertCommit"}, method={RequestMethod.POST})
    public void revertCommit(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String commit) throws Exception {
        if (StringUtils.isBlank((String)commit)) {
            throw new IllegalArgumentException("Missing 'commit' request parameter");
        }
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        this.writeGitRevertResponse(resp, this.projectsGitService.revertSingleCommit(authCtx, projectKey, commit));
    }

    @AuditedCall(value={"msgType", "project-git-drop-and-rebuild", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/actions/dropAndRebuild"}, method={RequestMethod.POST})
    public void dropAndRebuild(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(required=false, defaultValue="false") boolean iKnowWhatIAmDoing) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.projectsGitService.dropAndRebuild(t, projectKey, iKnowWhatIAmDoing);
        }
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "project-git-refs-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/lib-git-refs/"}, method={RequestMethod.GET})
    public void getExternalLibs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        try (Transaction t = this.transactionService.beginRead();){
            PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)this.gitRefsService.getProjectExternalLibraries(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "project-git-refs-set", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/lib-git-refs/"}, method={RequestMethod.POST})
    @ResponseBody
    public void addProjectGitReference(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody AddProjectGitReferenceRequest body) throws Exception {
        String refPath;
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            GitModel.GitReference gitReference = new GitModel.GitReference();
            gitReference.checkout = body.checkout;
            gitReference.remote = body.repository;
            gitReference.remoteLogin = body.login;
            gitReference.remotePassword = body.password;
            gitReference.remotePath = body.pathInGitRepository;
            RelFile libDirectory = AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey);
            if (!libDirectory.appendPath_withoutDirectoryTraversalCheck(body.localTargetPath).isStrictChildOf(libDirectory)) {
                throw new IllegalArgumentException("Supplied git reference path is invalid");
            }
            refPath = this.gitRefsService.setProjectGitReference(projectKey, gitReference, body.localTargetPath, body.addToPythonPath);
            t.commit("Add external git reference");
        }
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)this.gitRefsService.startPullProjectGitRef_NT(projectKey, refPath, authCtx));
    }

    @AuditedCall(value={"msgType", "project-git-refs-set", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/lib-git-refs/**"}, method={RequestMethod.PUT})
    @ResponseBody
    public void setProjectGitReference(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody SetProjectGitReferenceRequest body) throws Exception {
        String refPath;
        String gitReferencePath = PublicAPIProjectsGitController.getPathMatchingPattern(req);
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            GitModel.GitReference gitReference = this.gitRefsService.getProjectGitReference(projectKey, gitReferencePath);
            gitReference.checkout = body.checkout;
            gitReference.remote = body.repository;
            gitReference.remoteLogin = body.login;
            gitReference.remotePassword = body.password;
            gitReference.remotePath = body.pathInGitRepository;
            RelFile libDirectory = AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey);
            if (!libDirectory.appendPath_withoutDirectoryTraversalCheck(gitReferencePath).isStrictChildOf(libDirectory)) {
                throw new IllegalArgumentException("Supplied git reference path is invalid");
            }
            boolean addPythonPath = false;
            refPath = this.gitRefsService.setProjectGitReference(projectKey, gitReference, gitReferencePath, addPythonPath);
            t.commit("Set external git reference");
        }
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)refPath);
    }

    @AuditedCall(value={"msgType", "project-git-refs-rm", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/lib-git-refs/**"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeProjectGitReference(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam boolean deleteDirectory) throws Exception {
        String gitReferencePath = PublicAPIProjectsGitController.getPathMatchingPattern(req);
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.gitRefsService.removeProjectGitReference(projectKey, gitReferencePath, deleteDirectory);
            t.commit("Remove external git reference");
        }
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "project-git-refs-reset", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/lib-git-refs/action/reset"}, method={RequestMethod.POST})
    @ResponseBody
    public void resetProjectGitReference(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody PullProjectGitReferenceRequest body) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)this.gitRefsService.startPullProjectGitRef_NT(projectKey, body.gitRef, authCtx));
    }

    @AuditedCall(value={"msgType", "project-git-refs-push", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/lib-git-refs/action/push"}, method={RequestMethod.POST})
    @ResponseBody
    public void pushProjectGitReference(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody PushProjectGitReferenceRequest body) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)this.gitRefsService.startPushProjectGitRef_NT(projectKey, body.commitMessage, body.gitRef, authCtx));
    }

    @AuditedCall(value={"msgType", "project-git-refs-reset-all", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/actions/git-refs/reset-all"}, method={RequestMethod.POST})
    @ResponseBody
    public void pullProjectGitReferences(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)this.gitRefsService.startPullProjectGitRefs_NT(projectKey, authCtx));
    }

    @AuditedCall(value={"msgType", "project-git-refs-push-all", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/git/actions/git-refs/push-all"}, method={RequestMethod.POST})
    @ResponseBody
    public void pushProjectGitReferences(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody PushProjectGitReferencesRequest body) throws Exception {
        AuthCtx authCtx = this.checkProjectPermission(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)this.gitRefsService.startPushProjectGitRefs_NT(projectKey, body.commitMessage, authCtx));
    }

    private void writeGitRevertResponse(HttpServletResponse resp, InfoMessage.InfoMessages messages) throws IOException {
        GitActionResult response = new GitActionResult();
        boolean bl = response.success = !messages.anyFatal();
        if (messages.anyMessage) {
            response.logs = messages.report("\n");
        }
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)response);
    }

    private void setOrRemoveRemote_NT(HttpServletRequest req, HttpServletResponse resp, String projectKey, String remoteName, @Nullable String remoteUrl) throws DKUSecurityException, IOException, CodedException, GitAPIException, LimitsStatusComputer.LicenseLimitException {
        String response;
        RemoteGitPermission remoteGitPermission = this.checkUseRemoteGitPermission(req, projectKey);
        AuthCtx authCtx = remoteGitPermission.authCtx;
        boolean useRemoteGit = remoteGitPermission.useRemoteGit;
        if (remoteUrl != null) {
            response = this.projectsGitService.addOrSetRepository_NT(projectKey, remoteName, remoteUrl, authCtx);
            this.projectsGitService.setUpstreamForLocalBranches_NT(authCtx, remoteName, projectKey);
        } else {
            response = this.projectsGitService.removeRemoteRepository_NT(projectKey, remoteName, authCtx);
        }
        if (remoteUrl != null && !useRemoteGit) {
            this.setUseRemoteGitFlag_NT(authCtx, projectKey, true);
        } else if (remoteUrl == null && useRemoteGit) {
            this.setUseRemoteGitFlag_NT(authCtx, projectKey, false);
        }
        PublicAPIProjectsGitController.writeJSON((HttpServletResponse)resp, (Object)response);
    }

    private void setUseRemoteGitFlag_NT(AuthCtx authCtx, String projectKey, boolean value) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            project.settings.useRemoteGit = value ? Boolean.valueOf(true) : null;
            this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
            rwt.commit((value ? "Setup " : "Clear") + " git remote repository");
        }
    }

    private List<GitModel.GitRemote> listRemotes(String projectKey, boolean useRemoteGit, AuthCtx authCtx) throws IOException, GitAPIException {
        List<Object> response = useRemoteGit ? this.projectsGitService.getFullStatus_NT((String)projectKey, (AuthCtx)authCtx).remotes : new ArrayList<GitModel.GitRemote>();
        return response;
    }

    private RemoteGitPermission checkUseRemoteGitPermission(HttpServletRequest req, String projectKey) throws DKUSecurityException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            boolean useRemoteGit = project != null && project.settings.useRemoteGit != null && project.settings.useRemoteGit != false;
            RemoteGitPermission remoteGitPermission = new RemoteGitPermission(authCtx, useRemoteGit);
            return remoteGitPermission;
        }
    }

    private AuthCtx checkProjectPermission(HttpServletRequest req, String projectKey, Privileges.ProjectLevelPrivilegeType permission) throws DKUSecurityException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{permission});
        }
        return authCtx;
    }

    private static TaggableObjectsService.TaggableObjectRef objectRef(String projectKey) {
        return new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey);
    }

    private static boolean isInvalidRefName(String name) {
        return StringUtils.isBlank((String)name) || name.contains("..") || Pattern.compile("[\\x00-\\x1F\\x7F\\x20~^:]").matcher(name).find() || Pattern.compile("[?*\\[]").matcher(name).find() || name.startsWith("/") || name.contains("//") || name.endsWith("/") || name.endsWith(".") || name.contains("@{") || name.contains("\\") || ((Stream)Arrays.stream(name.split("/")).sequential()).anyMatch(component -> component.startsWith(".") || component.endsWith(".lock"));
    }

    private static String getPathMatchingPattern(HttpServletRequest req) {
        String path = req.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE).toString();
        String pattern = req.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE).toString();
        return new AntPathMatcher().extractPathWithinPattern(pattern, path);
    }

    private static class RemoteGitPermission {
        public final AuthCtx authCtx;
        public final boolean useRemoteGit;

        public RemoteGitPermission(AuthCtx authCtx, boolean useRemoteGit) {
            this.authCtx = authCtx;
            this.useRemoteGit = useRemoteGit;
        }
    }

    static class GitBranch {
        public String name;

        GitBranch() {
        }
    }

    static class GitStatus {
        public final String currentBranch;
        public List<GitModel.GitRemote> remotes;
        public final GitModel.GitTrackingCount trackingCount;
        public final boolean clean;
        public final boolean hasUncommittedChanges;
        public final Set<String> added;
        public final Set<String> changed;
        public final Set<String> removed;
        public final Set<String> missing;
        public final Set<String> modified;
        public final Set<String> conflicting;
        public final Set<String> untracked;
        public final Set<String> untrackedFolders;
        public String originProjectKey;
        public GitModel.GitTrackingCount trackingCountWithOriginProject;

        public GitStatus(GitModel.GitFullStatus fullStatus, GitModel.GitWorkingTreeStatus wtStatus) {
            this.currentBranch = fullStatus.currentBranch;
            this.trackingCount = fullStatus.trackingCount;
            this.remotes = fullStatus.remotes;
            this.clean = wtStatus.clean;
            this.hasUncommittedChanges = wtStatus.hasUncommittedChanges;
            this.added = wtStatus.added;
            this.changed = wtStatus.changed;
            this.removed = wtStatus.removed;
            this.missing = wtStatus.missing;
            this.modified = wtStatus.modified;
            this.conflicting = wtStatus.conflicting;
            this.untracked = wtStatus.untracked;
            this.untrackedFolders = wtStatus.untrackedFolders;
            this.originProjectKey = fullStatus.originProjectKey;
            this.trackingCountWithOriginProject = fullStatus.trackingCountWithOriginProject;
        }
    }

    static class GitActionResult {
        public boolean success;
        public String output;
        public String logs;

        public GitActionResult() {
        }

        public GitActionResult(GitRemoteCommands.GitCommandResult gitCommandResult, DKUtils.SmartLogTailBuilder logBuilder) {
            this.success = gitCommandResult.commandSucceeded;
            this.output = Joiner.on((String)"\n").join((Iterable)logBuilder.get().getLines());
            this.logs = gitCommandResult.messages.report("\n");
        }
    }

    static class CreateBranchRequest {
        public String name;
        public String commit;
        public boolean duplicateProject;
        public String targetProjectKey;
        public String targetProjectFolderId;

        CreateBranchRequest() {
        }
    }

    static class CreateBranchResult
    extends GitActionResult {
        public String targetProjectKey;

        CreateBranchResult() {
        }
    }

    static class DeleteBranchRequest {
        public String name;
        public boolean remote;
        public boolean deleteRemotely;
        public boolean forceDelete;

        DeleteBranchRequest() {
        }
    }

    private static class CommitRequest {
        public String message;

        private CommitRequest() {
        }
    }

    static class GitLog {
        public List<GitLogEntry> entries;
        public String nextCommit;

        GitLog() {
        }
    }

    static class GitDiff {
        public final GitLogEntry commitFrom;
        public final GitLogEntry commitTo;
        public final int addedLines;
        public final int removedLines;
        public final int changedFiles;
        public final List<DiffEntry> entries;

        public GitDiff(DSSGitModel.ObjectDiff diff) {
            this.commitFrom = diff.commitFrom != null ? new GitLogEntry(diff.commitFrom) : null;
            this.commitTo = diff.commitTo != null ? new GitLogEntry(diff.commitTo) : null;
            this.addedLines = diff.addedLines;
            this.removedLines = diff.removedLines;
            this.changedFiles = diff.changedFiles;
            this.entries = diff.diffEntries != null ? diff.diffEntries.stream().map(DiffEntry::new).collect(Collectors.toList()) : null;
        }

        public GitDiff(GitModel.SingleCommitObjectDiff diff) {
            this.commitFrom = diff.commit != null ? new GitLogEntry(diff.commit) : null;
            this.commitTo = null;
            this.addedLines = diff.addedLines;
            this.removedLines = diff.removedLines;
            this.changedFiles = diff.changedFiles;
            this.entries = diff.diffEntries != null ? diff.diffEntries.stream().map(DiffEntry::new).collect(Collectors.toList()) : null;
        }
    }

    static class CreateTagRequest {
        public String name;
        public String reference;
        public String message;

        CreateTagRequest() {
        }
    }

    static class DeleteTagRequest {
        public String name;

        DeleteTagRequest() {
        }
    }

    public static class AddProjectGitReferenceRequest {
        String repository;
        String login;
        String password;
        String checkout;
        String pathInGitRepository;
        String localTargetPath;
        boolean addToPythonPath;
    }

    public static class SetProjectGitReferenceRequest {
        String repository;
        String login;
        String password;
        String checkout;
        String pathInGitRepository;
    }

    public static class PullProjectGitReferenceRequest {
        String gitRef;
    }

    public static class PushProjectGitReferenceRequest {
        String gitRef;
        String commitMessage;
    }

    public static class PushProjectGitReferencesRequest {
        String commitMessage;
    }

    static class GitTag {
        public final String commit;
        public final String shortName;
        public final String name;
        public final String message;
        public final String timestamp;
        public final String author;

        public GitTag(GitModel.GitTag tag, boolean includeCommit) {
            this.commit = includeCommit ? tag.commitId : null;
            this.name = tag.name;
            this.shortName = tag.shortName;
            if (tag.annotations != null) {
                this.message = StringUtils.isBlank((String)tag.annotations.message) ? null : tag.annotations.message;
                this.timestamp = DKUDateUtils.isoFormatUTC((long)tag.annotations.timestamp);
                this.author = tag.annotations.authorName;
            } else {
                this.message = null;
                this.timestamp = null;
                this.author = null;
            }
        }
    }

    static class FileChange {
        public final int addedLines;
        public final int removedLines;
        public final List<String> patch;

        public FileChange(GitModel.FileChange fileChange) {
            this.addedLines = fileChange.addedLines;
            this.removedLines = fileChange.removedLines;
            this.patch = fileChange.c;
        }
    }

    static class DiffEntry {
        public final String changeType;
        public final String oldPath;
        public final String newPath;
        public final FileChange fileChange;

        public DiffEntry(GitModel.DKUDiffEntry entry) {
            this.changeType = entry.changeType != null ? entry.changeType.name() : null;
            this.oldPath = entry.oldPath;
            this.newPath = entry.newPath;
            this.fileChange = entry.fileChange != null ? new FileChange(entry.fileChange) : null;
        }
    }

    static class GitLogEntry {
        public final String author;
        public final String timestamp;
        public final String commit;
        public final String message;
        public final Set<GitTag> tags;

        public GitLogEntry(GitModel.DKULogEntry entry) {
            this.commit = entry.commitId;
            this.timestamp = DKUDateUtils.isoFormatUTC((long)entry.timestamp);
            this.author = entry.author;
            this.message = entry.message;
            Set tags = entry.tags.stream().map(tag -> new GitTag((GitModel.GitTag)tag, false)).collect(Collectors.toSet());
            this.tags = tags.isEmpty() ? null : tags;
        }
    }

    static class CreateGitBranchRequest {
        public String name;
        public String commit;

        CreateGitBranchRequest() {
        }
    }
}

