/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.opensearch;

import com.dataiku.dss.shadelib.org.apache.lucene.search.Explanation;
import java.util.Locale;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CombineFunction {
    MULTIPLY{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)(queryScore * Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation boostExpl = Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0]);
            Explanation minExpl = Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, boostExpl});
            return Explanation.match((Number)Float.valueOf(queryExpl.getValue().floatValue() * minExpl.getValue().floatValue()), (String)"function score, product of:", (Explanation[])new Explanation[]{queryExpl, minExpl});
        }
    }
    ,
    REPLACE{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)Math.min(funcScore, maxBoost);
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation boostExpl = Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0]);
            return Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, boostExpl});
        }
    }
    ,
    SUM{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)(queryScore + Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation minExpl = Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost) + queryExpl.getValue().floatValue()), (String)"sum of", (Explanation[])new Explanation[]{queryExpl, minExpl});
        }
    }
    ,
    AVG{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)((Math.min(funcScore, maxBoost) + queryScore) / 2.0);
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation minExpl = Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((Number)Float.valueOf((float)((double)(Math.min(funcExpl.getValue().floatValue(), maxBoost) + queryExpl.getValue().floatValue()) / 2.0)), (String)"avg of", (Explanation[])new Explanation[]{queryExpl, minExpl});
        }
    }
    ,
    MIN{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)Math.min(queryScore, Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation innerMinExpl = Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((Number)Float.valueOf(Math.min(Math.min(funcExpl.getValue().floatValue(), maxBoost), queryExpl.getValue().floatValue())), (String)"min of", (Explanation[])new Explanation[]{queryExpl, innerMinExpl});
        }
    }
    ,
    MAX{

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return (float)Math.max(queryScore, Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation innerMinExpl = Explanation.match((Number)Float.valueOf(Math.min(funcExpl.getValue().floatValue(), maxBoost)), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((Number)Float.valueOf(maxBoost), (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((Number)Float.valueOf(Math.max(Math.min(funcExpl.getValue().floatValue(), maxBoost), queryExpl.getValue().floatValue())), (String)"max of:", (Explanation[])new Explanation[]{queryExpl, innerMinExpl});
        }
    };


    public abstract float combine(double var1, double var3, double var5);

    public abstract Explanation explain(Explanation var1, Explanation var2, float var3);

    public static CombineFunction fromString(String combineFunction) {
        return CombineFunction.valueOf(combineFunction.toUpperCase(Locale.ROOT));
    }
}

