/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.ml.prediction;

import com.dataiku.dip.analysis.model.GridsearchData;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.spark.ml.prediction.EstimatorSelector$;
import com.dataiku.dip.spark.ml.prediction.Metrics;
import com.dataiku.dip.spark.ml.prediction.Metrics$;
import com.dataiku.dip.spark.ml.prediction.ParameterResolution$;
import com.dataiku.dip.spark.ml.prediction.ParameterSelection;
import com.dataiku.dip.spark.ml.prediction.ParameterSelection$;
import com.dataiku.dip.spark.ml.prediction.ParameterSelection$FoldScore$;
import com.dataiku.dip.spark.ml.prediction.Validator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.JsonConverters$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import org.apache.spark.ml.Estimator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001\u0002\u0015*\u0001YB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000bC\u0003U\u0001\u0011\u0005Q\u000bC\u0004\\\u0001\t\u0007I\u0011\u0001/\t\ru\u0003\u0001\u0015!\u0003?\u0011\u001dq\u0006A1A\u0005\u0002qCaa\u0018\u0001!\u0002\u0013q\u0004b\u00021\u0001\u0005\u0004%\t\u0001\u0018\u0005\u0007C\u0002\u0001\u000b\u0011\u0002 \t\u000f\t\u0004!\u0019!C\u00019\"11\r\u0001Q\u0001\nyBq\u0001\u001a\u0001C\u0002\u0013\u0005A\f\u0003\u0004f\u0001\u0001\u0006IA\u0010\u0005\bM\u0002\u0011\r\u0011\"\u0001]\u0011\u00199\u0007\u0001)A\u0005}!9\u0001\u000e\u0001b\u0001\n\u0003a\u0006BB5\u0001A\u0003%a\bC\u0004k\u0001\t\u0007I\u0011\u0001/\t\r-\u0004\u0001\u0015!\u0003?\u0011\u001da\u0007A1A\u0005\u0002qCa!\u001c\u0001!\u0002\u0013q\u0004\"\u00028\u0001\t\u0013y\u0007\"\u0002@\u0001\t\u0013y\bbBA\t\u0001\u0011%\u00111\u0003\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\t)\u0003\u0001C\u0005\u0003OAq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0006bBA_\u0001\u0011\u0005\u0011qX\u0004\b\u0003OL\u0003\u0012AAu\r\u0019A\u0013\u0006#\u0001\u0002l\"1AK\tC\u0001\u0003[D\u0011\"a<#\u0005\u0004%\t!!=\t\u0011\u0005e(\u0005)A\u0005\u0003gD\u0011\"a?#\u0005\u0004%\t!!@\t\u0011\t-!\u0005)A\u0005\u0003\u007f\u0014\u0011#R:uS6\fGo\u001c:TK2,7\r^8s\u0015\tQ3&\u0001\u0006qe\u0016$\u0017n\u0019;j_:T!\u0001L\u0017\u0002\u00055d'B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'A\u0002eSBT!AM\u001a\u0002\u000f\u0011\fG/Y5lk*\tA'A\u0002d_6\u001c\u0001a\u0005\u0002\u0001oA\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\f1\u0002\u001e:bS:4u\u000e\u001c3feB\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0003S>T\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\n!a)\u001b7f\u0003)\u0019wN]3QCJ\fWn\u001d\t\u0003\u0011:k\u0011!\u0013\u0006\u0003U)S!a\u0013'\u0002\u000b5|G-\u001a7\u000b\u00055{\u0013\u0001C1oC2L8/[:\n\u0005=K%!\n*fg>dg/\u001a3DY\u0006\u001c8/[2bYB\u0013X\rZ5di&|gnQ8sKB\u000b'/Y7t\u00039iw\u000eZ3mS:<\u0007+\u0019:b[N\u0004\"\u0001\u0013*\n\u0005MK%\u0001\t)sKR\u0013\u0018-\u001b8Qe\u0016$\u0017n\u0019;j_:lu\u000eZ3mS:<\u0007+\u0019:b[N\fa\u0001P5oSRtD\u0003\u0002,Y3j\u0003\"a\u0016\u0001\u000e\u0003%BQ!\u0010\u0003A\u0002yBQA\u0012\u0003A\u0002\u001dCQ\u0001\u0015\u0003A\u0002E\u000b\u0011\"\u00192peR4\u0015\u000e\\3\u0016\u0003y\n!\"\u00192peR4\u0015\u000e\\3!\u0003A!X-\u001c9TG>\u0014Xm\u001d$pY\u0012,'/A\tuK6\u00048kY8sKN4u\u000e\u001c3fe\u0002\n!#Y2uk\u0006d7kY8sKN4u\u000e\u001c3fe\u0006\u0019\u0012m\u0019;vC2\u001c6m\u001c:fg\u001a{G\u000eZ3sA\u0005\u0011rM]5e'\u000e|'/Z:UK6\u0004h)\u001b7f\u0003M9'/\u001b3TG>\u0014Xm\u001d+f[B4\u0015\u000e\\3!\u0003I9'/\u001b3TG>\u0014Xm]\"paf4\u0015\u000e\\3\u0002'\u001d\u0014\u0018\u000eZ*d_J,7oQ8qs\u001aKG.\u001a\u0011\u0002\u001d\u001d\u0014\u0018\u000eZ*d_J,7OR5mK\u0006yqM]5e'\u000e|'/Z:GS2,\u0007%A\the&$7)\u001a7mgR+W\u000e\u001d$jY\u0016\f!c\u001a:jI\u000e+G\u000e\\:UK6\u0004h)\u001b7fA\u0005\trM]5e\u0007\u0016dGn]\"paf4\u0015\u000e\\3\u0002%\u001d\u0014\u0018\u000eZ\"fY2\u001c8i\u001c9z\r&dW\rI\u0001\u000eOJLGmQ3mYN4\u0015\u000e\\3\u0002\u001d\u001d\u0014\u0018\u000eZ\"fY2\u001ch)\u001b7fA\u0005Y1m\u001c9z\u0003:$Wj\u001c<f)\u0011\u0001\bP\u001f?\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018\u0001\u00024jY\u0016T!!\u001e\"\u0002\u00079Lw.\u0003\u0002xe\n!\u0001+\u0019;i\u0011\u0015Ix\u00031\u0001?\u0003\u0019y'/[4j]\")1p\u0006a\u0001}\u0005!1m\u001c9z\u0011\u0015ix\u00031\u0001?\u0003\u0011iwN^3\u0002\u000bM,G/\u001e9\u0015\t\u0005\u0005\u0011q\u0001\t\u0004q\u0005\r\u0011bAA\u0003s\t!QK\\5u\u0011\u001d\tI\u0001\u0007a\u0001\u0003\u0017\tqA\u001c)pS:$8\u000fE\u00029\u0003\u001bI1!a\u0004:\u0005\rIe\u000e^\u0001\bG2,\u0017M\\;q)\t\t)\u0002E\u00029\u0003/I1!!\u0007:\u0005\u0019\te.\u001f,bY\u0006I\u0011MY8si\"{wn\u001b\u000b\u0003\u0003?\u00012\u0001OA\u0011\u0013\r\t\u0019#\u000f\u0002\b\u0005>|G.Z1o\u0003\u0019!W/\u001c9feR!\u0011\u0011AA\u0015\u0011\u001d\tYc\u0007a\u0001\u0003[\t\u0011BZ8mIN\u001bwN]3\u0011\t\u0005=\u00121\u000b\b\u0005\u0003c\tyE\u0004\u0003\u00024\u00055c\u0002BA\u001b\u0003\u0017rA!a\u000e\u0002J9!\u0011\u0011HA$\u001d\u0011\tY$!\u0012\u000f\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u00116\u0003\u0019a$o\\8u}%\tA'\u0003\u00023g%\u0011\u0001'M\u0005\u0003]=J!\u0001L\u0017\n\u0005)Z\u0013bAA)S\u0005\u0011\u0002+\u0019:b[\u0016$XM]*fY\u0016\u001cG/[8o\u0013\u0011\t)&a\u0016\u0003\u0013\u0019{G\u000eZ*d_J,'bAA)S\u0005q\u0001O]8dKN\u001c(+Z:vYR\u001cHCAA\u0001\u0003QIg.\u001b;jC2\u001cF/\u0019:uS:<\u0007k\\5oiR1\u0011\u0011MA4\u0003/\u0003B!a\f\u0002d%!\u0011QMA,\u0005]1\u0016\r\\5eCRLwN\\*uCJ$\u0018N\\4Q_&tG\u000fC\u0004\u0002ju\u0001\r!a\u001b\u0002\u0015\u0015\u001cH/[7bi>\u00148\u000f\u0005\u0004\u0002n\u0005]\u0014Q\u0010\b\u0005\u0003_\n\u0019H\u0004\u0003\u0002>\u0005E\u0014\"\u0001\u001e\n\u0007\u0005U\u0014(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00141\u0010\u0002\u0005\u0019&\u001cHOC\u0002\u0002ve\u0002b!a \u0002\u000e\u0006EUBAAA\u0015\ra\u00131\u0011\u0006\u0004]\u0005\u0015%\u0002BAD\u0003\u0013\u000ba!\u00199bG\",'BAAF\u0003\ry'oZ\u0005\u0005\u0003\u001f\u000b\tIA\u0005FgRLW.\u0019;peB\u0019\u0001(a%\n\u0007\u0005U\u0015HA\u0004O_RD\u0017N\\4\t\u000f\u0005eU\u00041\u0001\u0002\u001c\u000611oY8sKJ\u0004B!!(\u0002$:\u0019q+a(\n\u0007\u0005\u0005\u0016&A\u0004NKR\u0014\u0018nY:\n\t\u0005\u0015\u0016q\u0015\u0002\u0007'\u000e|'/\u001a:\u000b\u0007\u0005\u0005\u0016&A\u000bhKR$&/Y5oS:<Wi\u001d;j[\u0006$xN]:\u0015\r\u00055\u00161WA[!\u001dA\u0014qVA1\u0003WJ1!!-:\u0005\u0019!V\u000f\u001d7fe!9\u0011\u0011\u000e\u0010A\u0002\u0005-\u0004bBAM=\u0001\u0007\u00111T\u0001\u0011M&dG/\u001a:FgRLW.\u0019;peN$B!a\u001b\u0002<\"9\u0011\u0011N\u0010A\u0002\u0005-\u0014a\u0001:v]R1\u0011QPAa\u0003\u0007Dq!!\u001b!\u0001\u0004\tY\u0007C\u0004\u0002F\u0002\u0002\r!a2\u0002\u000f\u0011\fG/Y:fiB!\u0011\u0011ZAq\u001d\u0011\tY-!8\u000f\t\u00055\u0017\u0011\u001c\b\u0005\u0003\u001f\f9N\u0004\u0003\u0002R\u0006Ug\u0002BA\u001f\u0003'L!!a#\n\t\u0005\u001d\u0015\u0011R\u0005\u0004]\u0005\u0015\u0015\u0002BAn\u0003\u0007\u000b1a]9m\u0013\u0011\t)(a8\u000b\t\u0005m\u00171Q\u0005\u0005\u0003G\f)OA\u0005ECR\fgI]1nK*!\u0011QOAp\u0003E)5\u000f^5nCR|'oU3mK\u000e$xN\u001d\t\u0003/\n\u001a\"AI\u001c\u0015\u0005\u0005%\u0018AC*M\u000b\u0016\u0003v\fV%N\u000bV\u0011\u00111\u001f\t\u0004q\u0005U\u0018bAA|s\t!Aj\u001c8h\u0003-\u0019F*R#Q?RKU*\u0012\u0011\u0002-\u001d\u0013\u0016\nR0T\u000b\u0006\u00136\tS0D\u000b2c5k\u0018$J\u0019\u0016+\"!a@\u0011\t\t\u0005!qA\u0007\u0003\u0005\u0007Q1A!\u0002C\u0003\u0011a\u0017M\\4\n\t\t%!1\u0001\u0002\u0007'R\u0014\u0018N\\4\u0002/\u001d\u0013\u0016\nR0T\u000b\u0006\u00136\tS0D\u000b2c5k\u0018$J\u0019\u0016\u0003\u0003")
public class EstimatorSelector {
    private final ResolvedClassicalPredictionCoreParams coreParams;
    private final PreTrainPredictionModelingParams modelingParams;
    private final File abortFile;
    private final File tempScoresFolder;
    private final File actualScoresFolder;
    private final File gridScoresTempFile;
    private final File gridScoresCopyFile;
    private final File gridScoresFile;
    private final File gridCellsTempFile;
    private final File gridCellsCopyFile;
    private final File gridCellsFile;

    public static String GRID_SEARCH_CELLS_FILE() {
        return EstimatorSelector$.MODULE$.GRID_SEARCH_CELLS_FILE();
    }

    public static long SLEEP_TIME() {
        return EstimatorSelector$.MODULE$.SLEEP_TIME();
    }

    public File abortFile() {
        return this.abortFile;
    }

    public File tempScoresFolder() {
        return this.tempScoresFolder;
    }

    public File actualScoresFolder() {
        return this.actualScoresFolder;
    }

    public File gridScoresTempFile() {
        return this.gridScoresTempFile;
    }

    public File gridScoresCopyFile() {
        return this.gridScoresCopyFile;
    }

    public File gridScoresFile() {
        return this.gridScoresFile;
    }

    public File gridCellsTempFile() {
        return this.gridCellsTempFile;
    }

    public File gridCellsCopyFile() {
        return this.gridCellsCopyFile;
    }

    public File gridCellsFile() {
        return this.gridCellsFile;
    }

    private Path copyAndMove(File origin, File copy, File move) {
        Files.copy(Paths.get(origin.getPath(), new String[0]), Paths.get(copy.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        return Files.move(Paths.get(copy.getPath(), new String[0]), Paths.get(move.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
    }

    private void setup(int nPoints) {
        Path path;
        if (this.tempScoresFolder().exists()) {
            DKUFileUtils.deleteDirectory((File)this.tempScoresFolder());
        }
        if (this.actualScoresFolder().exists()) {
            DKUFileUtils.deleteDirectory((File)this.actualScoresFolder());
        }
        this.tempScoresFolder().mkdir();
        this.actualScoresFolder().mkdir();
        if (this.gridScoresFile().exists()) {
            path = Files.copy(Paths.get(this.gridScoresFile().getPath(), new String[0]), Paths.get(this.gridScoresTempFile().getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        } else {
            int n;
            GridsearchData scores = new GridsearchData();
            scores.gridSize = nPoints;
            scores.nThreads = 1;
            PredictionModelingParams.GridSearchCrossValidationMode gridSearchCrossValidationMode = this.modelingParams.grid_search_params.mode;
            if (PredictionModelingParams.GridSearchCrossValidationMode.SHUFFLE.equals(gridSearchCrossValidationMode)) {
                n = 1;
            } else if (PredictionModelingParams.GridSearchCrossValidationMode.KFOLD.equals(gridSearchCrossValidationMode)) {
                n = this.modelingParams.grid_search_params.nFolds;
            } else {
                throw new UnsupportedOperationException(new StringBuilder(39).append("Cross validation mode ").append(gridSearchCrossValidationMode).append(" is not supported").toString());
            }
            scores.nSplits = n;
            scores.isFinalizing = false;
            scores.metric = this.modelingParams.metrics.evaluationMetric.name();
            JSON.prettyToFile((Object)scores, (File)this.gridScoresTempFile());
            path = this.copyAndMove(this.gridScoresTempFile(), this.gridScoresCopyFile(), this.gridScoresFile());
        }
        if (this.gridCellsFile().exists()) {
            Files.copy(Paths.get(this.gridCellsFile().getPath(), new String[0]), Paths.get(this.gridCellsTempFile().getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        PredictionModelIntrinsicPerf iperf = new PredictionModelIntrinsicPerf();
        iperf.gridSize = nPoints;
        iperf.gridCells = new ArrayList(nPoints);
        JSON.prettyToFile((Object)iperf, (File)this.gridCellsTempFile());
        this.copyAndMove(this.gridCellsTempFile(), this.gridCellsCopyFile(), this.gridCellsFile());
    }

    private Object cleanup() {
        Object object;
        try {
            DKUFileUtils.deleteDirectory((File)this.tempScoresFolder());
            DKUFileUtils.deleteDirectory((File)this.actualScoresFolder());
            this.gridScoresTempFile().delete();
            this.gridScoresCopyFile().delete();
            this.gridCellsTempFile().delete();
            object = BoxesRunTime.boxToBoolean((boolean)this.gridCellsCopyFile().delete());
        }
        catch (IOException e) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private boolean abortHook() {
        return this.abortFile().exists();
    }

    private void dumper(ParameterSelection.FoldScore foldScore) {
        String hash = Integer.toString(foldScore.hashCode());
        ParameterSelection$.MODULE$.LOGGER().info((Object)new StringBuilder(32).append("Dumping fold score with hash ").append(hash).append(" : ").append(JsonConverters$.MODULE$.toJson(foldScore)).toString());
        File scoreTmpFile = new File(this.tempScoresFolder(), hash);
        File scoreFinalFile = new File(this.actualScoresFolder(), hash);
        JsonConverters$.MODULE$.toFile(foldScore, scoreTmpFile);
        Files.move(Paths.get(scoreTmpFile.getPath(), new String[0]), Paths.get(scoreFinalFile.getPath(), new String[0]), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    private void processResults() {
        File[] scoreFiles = this.actualScoresFolder().listFiles();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scoreFiles)).nonEmpty()) {
            ParameterSelection$.MODULE$.LOGGER().info((Object)new StringBuilder(28).append("Processing ").append(scoreFiles.length).append(" fold score files").toString());
            ParameterSelection.FoldScore[] scores = (ParameterSelection.FoldScore[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scoreFiles)).map((Function1 & Serializable & scala.Serializable)file -> ParameterSelection$FoldScore$.MODULE$.fromJsonFile((File)file), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ParameterSelection.FoldScore.class)));
            GridsearchData gsDataTemp = (GridsearchData)JSON.parseFile((File)this.gridScoresFile(), GridsearchData.class);
            java.util.List list = gsDataTemp.gridPoints;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scores)).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.asGridsearchFoldScore(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GridsearchData.GridsearchFoldScore.class))))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)list.add(x$1)));
            JSON.prettyToFile((Object)gsDataTemp, (File)this.gridScoresTempFile());
            this.copyAndMove(this.gridScoresTempFile(), this.gridScoresCopyFile(), this.gridScoresFile());
            PredictionModelIntrinsicPerf gcDataTemp = (PredictionModelIntrinsicPerf)JSON.parseFile((File)this.gridCellsFile(), PredictionModelIntrinsicPerf.class);
            if (gcDataTemp.gridCells == null) {
                gcDataTemp.gridCells = new ArrayList(scores.length);
            }
            java.util.List list2 = gcDataTemp.gridCells;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scores)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.asGridCell(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PredictionModelIntrinsicPerf.GridCell.class))))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)list2.add(x$1)));
            gcDataTemp.gridSize = gcDataTemp.gridCells.size();
            gcDataTemp.usedGridSearch = gcDataTemp.gridSize > 1;
            JSON.prettyToFile((Object)gcDataTemp, (File)this.gridCellsTempFile());
            this.copyAndMove(this.gridCellsTempFile(), this.gridCellsCopyFile(), this.gridCellsFile());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scoreFiles)).foreach((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.delete()));
            return;
        }
        ParameterSelection$.MODULE$.LOGGER().info((Object)"No fold score files to process.");
    }

    private ParameterSelection.ValidationStartingPoint initialStartingPoint(List<Estimator<Nothing$>> estimators, Metrics.Scorer scorer) {
        if (estimators.isEmpty()) {
            throw new IllegalArgumentException("No estimators for initial training");
        }
        return new ParameterSelection.ValidationStartingPoint((Estimator<Nothing$>)((Estimator)estimators.head()), scorer.largerIsBetter() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY, 0);
    }

    private Tuple2<ParameterSelection.ValidationStartingPoint, List<Estimator<Nothing$>>> getTrainingEstimators(List<Estimator<Nothing$>> estimators, Metrics.Scorer scorer) {
        Tuple2 tuple2;
        block3: {
            try {
                java.util.List gridPoints = ((GridsearchData)JSON.parseFile((File)this.gridScoresTempFile(), GridsearchData.class)).gridPoints;
                if (gridPoints.isEmpty()) {
                    tuple2 = this.default$1(estimators, scorer);
                    break block3;
                }
                GridsearchData.GridsearchFoldScore bestPoint = scorer.largerIsBetter() ? (GridsearchData.GridsearchFoldScore)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(gridPoints).maxBy((Function1 & Serializable & scala.Serializable)x$13 -> x$13.score, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())) : (GridsearchData.GridsearchFoldScore)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(gridPoints).minBy((Function1 & Serializable & scala.Serializable)x$14 -> x$14.score, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                Map bestParams = JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(bestPoint.parameters).toMap(Predef$.MODULE$.$conforms());
                scala.collection.immutable.Set alreadyTrained = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(gridPoints).map((Function1 & Serializable & scala.Serializable)x -> JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(x.parameters).toMap(Predef$.MODULE$.$conforms()), Buffer$.MODULE$.canBuildFrom())).toSet();
                Map paramMapping = ((TraversableOnce)estimators.map((Function1 & Serializable & scala.Serializable)e -> new Tuple2(ParameterResolution$.MODULE$.extractParameters((Estimator<?>)e), e), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                List filtered = ((TraversableOnce)paramMapping.collect((PartialFunction)new scala.Serializable(null, alreadyTrained){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Set alreadyTrained$1;

                    public final <A1 extends Tuple2<Map<String, Object>, Estimator<Nothing$>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 != null) {
                            Map par = (Map)A1._1();
                            Estimator est = (Estimator)A1._2();
                            if (!JavaConversions$.MODULE$.deprecated$u0020setAsJavaSet((Set)this.alreadyTrained$1).contains(par)) {
                                return (B1)est;
                            }
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Tuple2<Map<String, Object>, Estimator<Nothing$>> x1) {
                        Tuple2<Map<String, Object>, Estimator<Nothing$>> tuple2 = x1;
                        if (tuple2 != null) {
                            Map par = (Map)tuple2._1();
                            if (!JavaConversions$.MODULE$.deprecated$u0020setAsJavaSet((Set)this.alreadyTrained$1).contains(par)) {
                                return true;
                            }
                        }
                        return false;
                    }
                    {
                        this.alreadyTrained$1 = alreadyTrained$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList();
                Estimator startingEstimator = (Estimator)paramMapping.getOrElse((Object)bestParams, (Function0 & Serializable & scala.Serializable)() -> {
                    ParameterSelection$.MODULE$.LOGGER().warn((Object)"Failed to find the best estimator among those proposed. This is strange.");
                    return (Estimator)filtered.head();
                });
                tuple2 = new Tuple2((Object)new ParameterSelection.ValidationStartingPoint((Estimator<Nothing$>)startingEstimator, Predef$.MODULE$.Double2double(bestPoint.score), alreadyTrained.size()), (Object)filtered);
            }
            catch (Exception e2) {
                ParameterSelection$.MODULE$.LOGGER().warn((Object)"Failed to parse a grid scores file correctly!", (Throwable)e2);
                tuple2 = this.default$1(estimators, scorer);
            }
        }
        return tuple2;
    }

    public List<Estimator<Nothing$>> filterEstimators(List<Estimator<Nothing$>> estimators) {
        scala.collection.immutable.Set set;
        try {
            set = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(((GridsearchData)JSON.parseFile((File)this.gridScoresFile(), GridsearchData.class)).gridPoints).map((Function1 & Serializable & scala.Serializable)x$15 -> JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(x$15.parameters).toMap(Predef$.MODULE$.$conforms()), Buffer$.MODULE$.canBuildFrom())).toSet();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException ? true : throwable2 instanceof NullPointerException) {
                ParameterSelection$.MODULE$.LOGGER().warn((Object)"Failed to parse a grid scores file");
                set = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            }
            throw throwable;
        }
        scala.collection.immutable.Set alreadyTrained = set;
        ParameterSelection$.MODULE$.LOGGER().info((Object)new StringBuilder(34).append(estimators.size()).append(" original parameter combinations: ").append(estimators.map((Function1 & Serializable & scala.Serializable)e -> ParameterResolution$.MODULE$.extractParameters((Estimator<?>)e), List$.MODULE$.canBuildFrom())).toString());
        ParameterSelection$.MODULE$.LOGGER().info((Object)new StringBuilder(31).append("already trained ").append(alreadyTrained.size()).append(" combinations: ").append(alreadyTrained.toList()).toString());
        return (List)estimators.filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)EstimatorSelector.$anonfun$filterEstimators$3(alreadyTrained, e)));
    }

    public Estimator<Nothing$> run(List<Estimator<Nothing$>> estimators, Dataset<Row> dataset) {
        this.setup(estimators.size());
        Metrics.Scorer scorer = Metrics$.MODULE$.getScorer(this.modelingParams.metrics, this.coreParams);
        ParameterSelection$.MODULE$.LOGGER().info((Object)new StringBuilder(25).append(estimators.size()).append(" estimators before filter").toString());
        Tuple2<ParameterSelection.ValidationStartingPoint, List<Estimator<Nothing$>>> tuple2 = this.getTrainingEstimators(estimators, scorer);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ParameterSelection.ValidationStartingPoint startingPoint = (ParameterSelection.ValidationStartingPoint)tuple2._1();
        List filteredEstimators = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)startingPoint, (Object)filteredEstimators);
        ParameterSelection.ValidationStartingPoint startingPoint2 = (ParameterSelection.ValidationStartingPoint)tuple22._1();
        List filteredEstimators2 = (List)tuple22._2();
        ParameterSelection$.MODULE$.LOGGER().info((Object)new StringBuilder(24).append(filteredEstimators2.size()).append(" estimators after filter").toString());
        Validator validator = ParameterSelection$.MODULE$.getValidator(this.modelingParams.grid_search_params, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.abortHook(), scorer, startingPoint2, (Function1<ParameterSelection.FoldScore, BoxedUnit>)(Function1 & Serializable & scala.Serializable)foldScore -> {
            this.dumper(foldScore);
            return BoxedUnit.UNIT;
        });
        Future estimator = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> validator.optimize((List<Estimator<Nothing$>>)filteredEstimators2, dataset), ExecutionContext.Implicits$.MODULE$.global());
        while (!estimator.isCompleted()) {
            this.processResults();
            Thread.sleep(EstimatorSelector$.MODULE$.SLEEP_TIME());
        }
        this.processResults();
        ParameterSelection$.MODULE$.LOGGER().info((Object)"Selection process complete.");
        Estimator est = (Estimator)Await$.MODULE$.result((Awaitable)estimator, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute());
        this.cleanup();
        return est;
    }

    private final Tuple2 default$1(List estimators$3, Metrics.Scorer scorer$1) {
        return new Tuple2((Object)this.initialStartingPoint((List<Estimator<Nothing$>>)estimators$3, scorer$1), (Object)estimators$3);
    }

    public static final /* synthetic */ boolean $anonfun$filterEstimators$3(scala.collection.immutable.Set alreadyTrained$2, Estimator e) {
        return !JavaConversions$.MODULE$.deprecated$u0020setAsJavaSet((Set)alreadyTrained$2).contains(ParameterResolution$.MODULE$.extractParameters(e));
    }

    public EstimatorSelector(File trainFolder, ResolvedClassicalPredictionCoreParams coreParams, PreTrainPredictionModelingParams modelingParams) {
        this.coreParams = coreParams;
        this.modelingParams = modelingParams;
        this.abortFile = new File(trainFolder, "stop_search");
        this.tempScoresFolder = new File(trainFolder, "scores_tmp");
        this.actualScoresFolder = new File(trainFolder, "scores_actual");
        this.gridScoresTempFile = new File(trainFolder, "grid_search_scores_tmp.json");
        this.gridScoresCopyFile = new File(trainFolder, "grid_search_scores_copy.json");
        this.gridScoresFile = new File(trainFolder, "grid_search_scores.json");
        this.gridCellsTempFile = new File(trainFolder, "grid_search_cells_tmp.json");
        this.gridCellsCopyFile = new File(trainFolder, "grid_search_cells_copy.json");
        this.gridCellsFile = new File(trainFolder, EstimatorSelector$.MODULE$.GRID_SEARCH_CELLS_FILE());
    }
}

