/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.treasuredata.client.model.TDExportFileFormatType;
import com.treasuredata.client.model.TDExportJobRequestBuilder;
import java.util.Date;
import java.util.Optional;
import org.immutables.builder.Builder;
import org.immutables.value.Value;

@Value.Style(typeBuilder="TDExportJobRequestBuilder")
public class TDExportJobRequest {
    private final String database;
    private final String table;
    private final Date from;
    private final Date to;
    private final TDExportFileFormatType fileFormat;
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String bucketName;
    private final String filePrefix;
    private final Optional<String> poolName;
    private final Optional<String> domainKey;

    @Deprecated
    public TDExportJobRequest(String database, String table, Date from, Date to, TDExportFileFormatType fileFormat, String accessKeyId, String secretAccessKey, String bucketName, String filePrefix, Optional<String> poolName) {
        this.database = database;
        this.table = table;
        this.from = (Date)from.clone();
        this.to = (Date)to.clone();
        this.fileFormat = fileFormat;
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.bucketName = bucketName;
        this.filePrefix = filePrefix;
        this.poolName = poolName;
        this.domainKey = Optional.empty();
    }

    private TDExportJobRequest(String database, String table, Date from, Date to, TDExportFileFormatType fileFormat, String accessKeyId, String secretAccessKey, String bucketName, String filePrefix, Optional<String> poolName, Optional<String> domainKey) {
        this.database = database;
        this.table = table;
        this.from = from;
        this.to = to;
        this.fileFormat = fileFormat;
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.bucketName = bucketName;
        this.filePrefix = filePrefix;
        this.poolName = poolName;
        this.domainKey = domainKey;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public Date getFrom() {
        return new Date(this.from.getTime());
    }

    public Date getTo() {
        return new Date(this.to.getTime());
    }

    public TDExportFileFormatType getFileFormat() {
        return this.fileFormat;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public Optional<String> getPoolName() {
        return this.poolName;
    }

    public Optional<String> getDomainKey() {
        return this.domainKey;
    }

    @Builder.Factory
    static TDExportJobRequest of(String database, String table, Date from, Date to, TDExportFileFormatType fileFormat, String accessKeyId, String secretAccessKey, String bucketName, String filePrefix, Optional<String> poolName, Optional<String> domainKey) {
        return new TDExportJobRequest(database, table, from, to, fileFormat, accessKeyId, secretAccessKey, bucketName, filePrefix, poolName, domainKey);
    }

    public static TDExportJobRequestBuilder builder() {
        return new TDExportJobRequestBuilder();
    }

    public String toString() {
        return "TDExportJobRequest{database='" + this.database + '\'' + ", table='" + this.table + '\'' + ", from=" + this.from.getTime() / 1000L + ", to=" + this.to.getTime() / 1000L + ", fileFormat='" + (Object)((Object)this.fileFormat) + '\'' + ", accessKeyId='" + this.accessKeyId + '\'' + ", bucketName='" + this.bucketName + '\'' + ", filePrefix='" + this.filePrefix + '\'' + '}';
    }
}

