/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.treasuredata.client.TDClientException;
import com.treasuredata.client.model.TDJob;
import com.treasuredata.client.model.TDSaveQueryRequest;
import java.util.Optional;

public class TDSavedQueryBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<String> cron = Optional.empty();
    private Optional<TDJob.Type> type = Optional.empty();
    private Optional<String> query = Optional.empty();
    private Optional<String> timezone = Optional.empty();
    private Optional<Long> delay = Optional.empty();
    private Optional<String> database = Optional.empty();
    private Optional<Integer> priority = Optional.empty();
    private Optional<Integer> retryLimit = Optional.empty();
    private Optional<String> result = Optional.empty();
    private Optional<TDJob.EngineVersion> engineVersion = Optional.empty();

    public TDSavedQueryBuilder setName(String name) {
        this.name = Optional.of(name);
        return this;
    }

    public TDSavedQueryBuilder setCron(String cron) {
        this.cron = Optional.of(cron);
        return this;
    }

    public TDSavedQueryBuilder setType(TDJob.Type type) {
        this.type = Optional.of(type);
        return this;
    }

    public TDSavedQueryBuilder setQuery(String query) {
        this.query = Optional.of(query);
        return this;
    }

    public TDSavedQueryBuilder setTimezone(String timezone) {
        this.timezone = Optional.of(timezone);
        return this;
    }

    public TDSavedQueryBuilder setDelay(long delay) {
        this.delay = Optional.of(delay);
        return this;
    }

    public TDSavedQueryBuilder setDatabase(String database) {
        this.database = Optional.of(database);
        return this;
    }

    public TDSavedQueryBuilder setPriority(int priority) {
        this.priority = Optional.of(priority);
        return this;
    }

    public TDSavedQueryBuilder setRetryLimit(int retryLimit) {
        this.retryLimit = Optional.of(retryLimit);
        return this;
    }

    public TDSavedQueryBuilder setResult(String result) {
        this.result = Optional.of(result);
        return this;
    }

    public TDSavedQueryBuilder setEngineVersion(TDJob.EngineVersion engineVersion) {
        this.engineVersion = Optional.ofNullable(engineVersion);
        return this;
    }

    private static <T> void checkPresence(Optional<T> opt, String errorMessage) {
        if (!opt.isPresent()) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_INPUT, errorMessage);
        }
    }

    public TDSaveQueryRequest build() {
        TDSavedQueryBuilder.checkPresence(this.name, "name is not set");
        TDSavedQueryBuilder.checkPresence(this.type, "job type is not set");
        TDSavedQueryBuilder.checkPresence(this.query, "query is not set");
        TDSavedQueryBuilder.checkPresence(this.timezone, "timezone is not set. Use UTC, US/Pacific, Asia/Tokyo, etc.");
        TDSavedQueryBuilder.checkPresence(this.database, "database is not set");
        return new TDSaveQueryRequest(this.name.get(), this.cron.orElse(""), this.type.get(), this.query.get(), this.timezone.get(), this.delay.orElse(0L), this.database.get(), this.priority.orElse(TDJob.Priority.NORMAL.toInt()), this.retryLimit.orElse(0), this.result.orElse(""), this.engineVersion.orElse(null));
    }

    protected TDSavedQueryBuilder(String name) {
        this.setName(name);
    }
}

