/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.spi.StandardLevel;
import org.geotools.util.logging.LoggerAdapter;
import org.geotools.util.logging.Logging;

public final class Log4J2Logger
extends LoggerAdapter {
    final Logger logger;
    public static final Level CONFIG = Level.forName((String)"CONFIG", (int)(StandardLevel.INFO.intLevel() + 50));
    public static final Level FINEST = Level.forName((String)"FINEST", (int)(StandardLevel.TRACE.intLevel() + 100));

    public Log4J2Logger(String name, Logger logger) {
        super(name);
        this.logger = logger;
    }

    private static Level toLog4JLevel(java.util.logging.Level level) {
        int n = level.intValue();
        switch (n / 100) {
            case 11: {
                return Level.FATAL;
            }
            case 10: {
                return Level.ERROR;
            }
            case 9: {
                return Level.WARN;
            }
            case 8: {
                return Level.INFO;
            }
            case 7: {
                return CONFIG;
            }
            case 5: 
            case 6: {
                return Level.DEBUG;
            }
            case 4: {
                return Level.TRACE;
            }
            case 3: {
                return FINEST;
            }
            case 0: 
            case 1: 
            case 2: {
                return Level.ALL;
            }
        }
        switch (n) {
            case -2147483648: {
                return Level.ALL;
            }
            case 0x7FFFFFFF: {
                return Level.OFF;
            }
        }
        if (n >= 0) {
            return Level.FATAL;
        }
        return Level.ALL;
    }

    private static java.util.logging.Level toJavaLevel(Level level) {
        int n = level.intLevel();
        if (n == StandardLevel.OFF.intLevel()) {
            return java.util.logging.Level.OFF;
        }
        if (n <= StandardLevel.FATAL.intLevel()) {
            return Logging.FATAL;
        }
        if (n <= StandardLevel.ERROR.intLevel()) {
            return java.util.logging.Level.SEVERE;
        }
        if (n <= StandardLevel.WARN.intLevel()) {
            return java.util.logging.Level.WARNING;
        }
        if (n <= StandardLevel.INFO.intLevel()) {
            return java.util.logging.Level.INFO;
        }
        if (n <= CONFIG.intLevel()) {
            return java.util.logging.Level.CONFIG;
        }
        if (n <= StandardLevel.DEBUG.intLevel()) {
            return java.util.logging.Level.FINE;
        }
        if (n <= StandardLevel.TRACE.intLevel()) {
            return java.util.logging.Level.FINER;
        }
        if (n <= FINEST.intLevel()) {
            return java.util.logging.Level.FINEST;
        }
        return java.util.logging.Level.ALL;
    }

    @Override
    public void setLevel(java.util.logging.Level level) {
        Configurator.setLevel((Logger)this.logger, (Level)Log4J2Logger.toLog4JLevel(level));
    }

    @Override
    public java.util.logging.Level getLevel() {
        return Log4J2Logger.toJavaLevel(this.logger.getLevel());
    }

    @Override
    public boolean isLoggable(java.util.logging.Level level) {
        return this.logger.isEnabled(Log4J2Logger.toLog4JLevel(level));
    }

    @Override
    public void log(java.util.logging.Level level, String message) {
        this.logger.log(Log4J2Logger.toLog4JLevel(level), message);
    }

    @Override
    public void log(java.util.logging.Level level, String message, Throwable thrown) {
        this.logger.log(Log4J2Logger.toLog4JLevel(level), message, thrown);
    }

    @Override
    public void severe(String message) {
        this.logger.error(message);
    }

    @Override
    public void warning(String message) {
        this.logger.warn(message);
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void config(String message) {
        this.logger.log(CONFIG, message);
    }

    @Override
    public void fine(String message) {
        this.logger.debug(message);
    }

    @Override
    public void finer(String message) {
        this.logger.trace(message);
    }

    @Override
    public void finest(String message) {
        this.logger.log(FINEST, message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Log4j2Logger: ");
        sb.append(this.getName() == null ? "anonymous" : this.getName());
        sb.append(" : ");
        sb.append(this.getLevel());
        sb.append(" (");
        sb.append(this.logger.getLevel());
        sb.append(")");
        return sb.toString();
    }
}

