/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import org.geotools.util.logging.LogbackLogger;
import org.geotools.util.logging.LoggerFactory;
import org.slf4j.Logger;

public class LogbackLoggerFactory
extends LoggerFactory<Logger> {
    private static LogbackLoggerFactory factory;

    protected LogbackLoggerFactory() throws NoClassDefFoundError {
        super(Logger.class);
    }

    public static synchronized LogbackLoggerFactory getInstance() throws NoClassDefFoundError {
        if (factory == null) {
            factory = new LogbackLoggerFactory();
        }
        return factory;
    }

    @Override
    protected Logger getImplementation(String name) {
        return org.slf4j.LoggerFactory.getLogger((String)name);
    }

    protected LogbackLogger wrap(String name, Logger implementation) {
        return new LogbackLogger(name, implementation);
    }

    @Override
    protected Logger unwrap(java.util.logging.Logger logger) {
        if (logger instanceof LogbackLogger) {
            return ((LogbackLogger)logger).logger;
        }
        return null;
    }

    @Override
    public String lookupConfiguration() {
        try {
            LoggerContext context = (LoggerContext)org.slf4j.LoggerFactory.getILoggerFactory();
            ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)context);
            return configurationWatchList.getMainURL().toString();
        }
        catch (Exception unknown) {
            return "unknown";
        }
    }
}

