/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;

public class DateDifferenceFunction
extends FunctionExpressionImpl {
    static final Set<String> SUPPORTED_TIME_UNITS = new HashSet<String>(Arrays.asList("s", "m", "h", "d"));
    static final String SUPPORTED_TIME_UNITS_STRING = SUPPORTED_TIME_UNITS.stream().collect(Collectors.joining(","));
    public static FunctionName NAME = new FunctionNameImpl("dateDifference", FunctionNameImpl.parameter("result", Long.class), FunctionNameImpl.parameter("a", Date.class), FunctionNameImpl.parameter("b", Date.class), FunctionNameImpl.parameter("timeUnits", String.class, 0, 1));

    public DateDifferenceFunction() {
        super(NAME);
    }

    @Override
    public String getName() {
        return NAME.getName();
    }

    public int getArgCount() {
        return NAME.getArgumentCount();
    }

    @Override
    public Object evaluate(Object feature) {
        Date a = (Date)this.getExpression(0).evaluate(feature, Date.class);
        Date b = (Date)this.getExpression(1).evaluate(feature, Date.class);
        if (a == null || b == null) {
            return null;
        }
        TimeUnit timeUnit = this.getTimeUnit();
        return timeUnit.convert(a.getTime() - b.getTime(), TimeUnit.MILLISECONDS);
    }

    private TimeUnit getTimeUnit() {
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        if (this.params.size() == 3) {
            try {
                timeUnit = (TimeUnit)((Object)this.getExpression(2).evaluate(null, TimeUnit.class));
                if (timeUnit == null) {
                    throw new IllegalArgumentException("The specified timeUnit should be one of " + SUPPORTED_TIME_UNITS_STRING);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse the specified timeUnit which should be one of " + SUPPORTED_TIME_UNITS_STRING, e);
            }
        }
        return timeUnit;
    }
}

