column.sampling <- function(column, nbrows) {
    if(!is.numeric(nbrows) || nbrows%%1 != 0 || nbrows<0) {
        stop(paste0("Invalid number of rows: ",nbrows))
    }
    if(is.null(column) || column=="") {
        stop("Invalid column name")
    }
    sampling <- {}
    sampling$samplingMethod <- "COLUMN_BASED"
    sampling$maxRecords <- nbrows
    return(sampling)
}