#' Get the info on a folder
#'
#' @param name the name of the folder
#' @return Map of properties of the folder
#'
#' @export
#' @importFrom httr POST
dkuManagedFolderInfo <- function(name, sensitiveInfo=FALSE) {
    getPathURL = dku_intercom__get_jek_or_backend_url("/managed-folders/get-info")
    ref = dku__resolve_smart_name(name)

    resp = POST(getPathURL,body = list(projectKey=dku__ref_to_pkey(ref), lookup=dku__ref_to_name(ref), sensitiveInfo=sensitiveInfo),
        encode="form",  dku__get_auth_headers(), dku_intercom__get_httr_config())

    dku__check_api_error(resp, "Failed to get Box info")
    data <- content(resp)

    return(data)
}
