using JSON
if isfile("remote-run-env-def.json")
    DKU_ENV = JSON.parsefile("remote-run-env-def.json")
    merge!(ENV, DKU_ENV["env"])
    println("DKU EXEC ENV")
    JSON.print(DKU_ENV, 2)
end

println("Executing Julia script: " * ARGS[1])

try
    include(ARGS[1])
catch e
    println("*************** Julia code failed **************\n")
    err = Dict(
        "detailedMessage" => "At line $(e.line): $(sprint(showerror, e.error))",
        "errorType" => nameof(typeof(e.error)),
        "message" => sprint(showerror, e.error)
    )
    open(joinpath(DKU_ENV["cwd"], "error.json"); write=true) do io
        print(io, JSON.json(err))
    end
    throw(e)
end
