(function() {
    'use strict';

    angular.module('dataiku.managedfolder').factory('ManagedFolderRenameService', renameService);

    function renameService(DataikuAPI, CreateModalFromTemplate) {
        function renameManagedFolder({
            scope,
            state,
            projectKey,
            managedFolderId,
            managedFolderCurrentName,
            onSave = () => {}
        }) {
            CreateModalFromTemplate(
                "/templates/taggable-objects/rename-modal.html",
                scope,
                null,
                (newScope) => {
                    newScope.objectName = managedFolderCurrentName;
                    newScope.uiState = { newName: managedFolderCurrentName };

                    newScope.go = () => {
                        const newName = newScope.uiState.newName;
                        DataikuAPI.managedfolder.rename(projectKey, managedFolderId, newName).then(() => {
                            newScope.dismiss();
                            onSave(newName);
                            state.reload();
                        }, setErrorInScope.bind(newScope));
                    }
            });
        }

        return { renameManagedFolder };
    }
})();
