(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This controller previously was in static/dataiku/js/simple_report/config_ui.js
    app.controller('StdAggregatedChartDefController', function($scope, ChartTypeChangeHandler, ChartColumnTypeUtils, CHART_TYPES, CHART_VARIANTS) {

        $scope.acceptMeasure = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data);
        };

        $scope.acceptDimensionOrHierarchy = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptDimensionOrHierarchy(data);
        };

        $scope.acceptDimension = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptDimension(data);
        };

        $scope.useMonoValuedMeasure = function(chart){
            return ((chart.def.genericDimension0.length || chart.def.genericHierarchyDimension.length) &&
                chart.def.genericDimension1.length &&
                chart.def.type !== CHART_TYPES.MULTI_COLUMNS_LINES) ||
                chart.def.variant === CHART_VARIANTS.waterfall;
        };

        $scope.useSecondGenericDimension = function(chart) {
            return (chart.def.genericDimension0.length || chart.def.genericHierarchyDimension.length || chart.def.genericDimension1.length) && chart.def.variant !== CHART_VARIANTS.waterfall;
        };

        $scope.getDim0List = (data) => ChartColumnTypeUtils.isHierarchy(data) ? $scope.chart.def.genericHierarchyDimension : $scope.chart.def.genericDimension0;
    });
})();
