(function () {
  "use strict";

    angular.module("dataiku.nestedFilters").factory("FiltersService", filtersService);

    function filtersService() {
        const filtersService = {
            getColumns,
            getSchema,
            hasSchema,
            getOtherMode
        };

        function getColumns(scope) {
            let schema = getSchema(scope);
            return schema && schema.columns || [];
        }

        function getOtherMode(mode) {
            if (mode==="&&") {return "||"}
            else if (mode==="||"){return "&&"}
            else {return "&&"}
        }

        function getSchema(scope) {
            if (scope.filterDesc.$status && scope.filterDesc.$status.schema) {
                return scope.filterDesc.$status.schema;
            } else if (scope.schema) {
                return scope.schema;
            } else {
                return {columns: []};
            }
        }

        function hasSchema(scope) {
            return (scope.filterDesc.$status && scope.filterDesc.$status.schema) || scope.schema;
        }

    return filtersService;
  }
})();
