(function () {
    "use strict";
    angular.module("dataiku.opals").factory("WorkspaceContextService", WorkspaceContextService);
  
    function WorkspaceContextService() {
        function context(stateInfo) {
            return new Promise((resolve, reject) => {
                if (stateInfo.toState.name === "workspaces.object") {
                    resolve({ ...stateInfo, ...{ context: [...stateInfo.context, stateInfo.toParams.objectType] } });
                } else {
                    reject(`WorkspaceContextService: Nominal route (${stateInfo.toState.name}) not matched`);
                }
            });
        }
  
        return { context };
    }
})();
