# encoding: utf-8
"""
Executor for containerized execution of llm fine-tuning recipe.
"""
import json
import logging

from dataiku.base.folder_context import build_folder_context
from dataiku.base.utils import ErrorMonitoringWrapper
from .runner import setup_log, read_execution

if __name__ == "__main__":
    setup_log()
    execution = read_execution()
    execution_dir_folder_context = build_folder_context(execution["executionPath"])

    with ErrorMonitoringWrapper():
        logging.info("Launching containerized fine-tuning recipe")
        logging.info(f"Context path: {execution['contextPath']}")
        if execution['type'] == 'RECIPE_FINE_TUNING_LLM':
            from dataiku.huggingface.fine_tuning.fine_tuning_recipe import main

            payload = json.loads(execution['payload'])
            main(execution["contextPath"],
                 payload["inputDatasetName"],
                 execution_dir_folder_context.read_json("desc.json"),
                 payload.get("validationDatasetName"),
                 payload.get("inputLlmHfId"),
                 payload.get("inputSavedModelFolderContext"),
                 payload.get("baseModelInCache"))
