from dataiku.doctor import step_constants
from dataiku.doctor.clustering.clustering_fit import clustering_fit
from dataiku.doctor.clustering.clustering_scorer import ClusteringModelScorer
from dataiku.doctor.utils.model_io import dump_model_to_folder


# This is used both by the recipes and by the doctor
def clustering_train_score_save(transformed_src, src_index,
                                preprocessing_params,
                                modeling_params,
                                model_folder_context,
                                listener, pipeline):
    """Trains one model and saves results to run_folder"""

    with listener.push_step(step_constants.ProcessingStep.STEP_FITTING):
        (clf, actual_params, cluster_labels, anomaly_scores, iperf) = clustering_fit(modeling_params, transformed_src)

    with listener.push_step(step_constants.ProcessingStep.STEP_SAVING):
        dump_model_to_folder(clf, model_folder_context, is_prediction=False)
        model_folder_context.write_json("actual_params.json", actual_params)
        model_folder_context.write_json("iperf.json", iperf)

    with listener.push_step(step_constants.ProcessingStep.STEP_SCORING):
        ClusteringModelScorer(clf, transformed_src, src_index, cluster_labels, preprocessing_params, modeling_params,
                              pipeline, model_folder_context, anomaly_scores=anomaly_scores).score()
