from dataiku.eda.types import Literal

import scipy.stats as sps

from dataiku.eda.computations.computation import UnivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.exceptions import NoDataError
from dataiku.eda.types import KurtosisModel, KurtosisResultModel


class Kurtosis(UnivariateComputation):
    @staticmethod
    def get_type() -> Literal["kurtosis"]:
        return "kurtosis"

    @staticmethod
    def build(params: KurtosisModel) -> 'Kurtosis':
        return Kurtosis(params['column'])

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> KurtosisResultModel:
        series = idf.float_col_no_missing(self.column)

        if len(series) == 0:
            raise NoDataError()

        return {"type": self.get_type(), "value": sps.kurtosis(series, bias=False, fisher=True)}
