from . import DatabricksJSONWriter


class SplitOrientedJSONWriter(DatabricksJSONWriter):
    NAME = "INPUT_SPLIT_ORIENTED_JSON"

    def __init__(self, client):
        super(SplitOrientedJSONWriter, self).__init__(client)

    def build_request_payload(self, input_df):
        payload = input_df.to_dict(orient='split')
        payload = {"dataframe_split": payload}
        return payload
