class EmbeddingDriftSettings(object):
    def __init__(self, should_be_computed=False):
        self.should_be_computed = should_be_computed
        self.params = None

    def with_params(self, params=None):
        self.params = params
        return self


class TextDriftSettings(EmbeddingDriftSettings):
    pass


class ImageDriftSettings(EmbeddingDriftSettings):
    def __init__(self, should_be_computed=False):
        super(ImageDriftSettings, self).__init__(should_be_computed)
        self.managed_folder_smart_id_cur = None
        self.managed_folder_smart_id_ref = None

    def with_params(self, params=None,
                    managed_folder_smart_id_cur=None,
                    managed_folder_smart_id_ref=None):
        super(ImageDriftSettings, self).with_params(params)
        self.managed_folder_smart_id_cur = managed_folder_smart_id_cur
        self.managed_folder_smart_id_ref = managed_folder_smart_id_ref
        return self
