from dataiku.doctor.exception import DriftException
import logging

logger = logging.getLogger(__name__)


def _handle_test_error(test, column, err, handle_drift_failure_as_error, default):
    if column is None:
        failure_drift_message = u"Failed to compute {}: {}".format(test, str(err))
    else:
        failure_drift_message = u"Failed to compute {} for column {} : {}".format(test, column, str(err))
    if handle_drift_failure_as_error:
        logger.exception(failure_drift_message)
        raise DriftException(failure_drift_message)
    else:
        logger.warning(failure_drift_message)
        return default
