from govern.models import EnrichedArtifact
import copy

class ArtifactActionHandler:
    def __init__(self, enriched_artifact, auth_ctx_identifier, params, client):
        """
        Instantiate a new artifact custom action script handler.

        :param dict enriched_artifact: a Python dict of the dku enriched artifact linked to the triggered action
        :param str auth_ctx_identifier: the auth context identifier that triggered the action
        :param dict params: a Python dict of the parameters to pass along with the triggered action
        :param :class:`~dataikuapi.govern_client.GovernClient` client: An instance of :class:`~dataikuapi.govern_client.GovernClient` to access the Govern API
        """

        self.enrichedArtifact = EnrichedArtifact(copy.deepcopy(enriched_artifact))
        self.authCtxIdentifier = auth_ctx_identifier
        self.params = params
        self.client = client
        self.message = ''
        self.status = 'SUCCESS'

instance = None

def get_artifact_action_handler():
    """
    Return the current instance of :class:`govern.core.ArtifactActionHandler`,
    previously set using :meth:`set_artifact_action_handler`

    :return: the instance of :class:`govern.core.ArtifactActionHandler` that was previously set with :meth:`set_artifact_action_handler`
    """
    if instance is not None:
        return instance
    raise Exception("Handler not set")

def set_artifact_action_handler(handler):
    """
    Set the current instance of :class:`govern.core.ArtifactActionHandler`

    :return: None
    """
    global instance
    instance = handler
