#!/bin/bash
set -e

DATA_DIR="/home/dataiku/data"

# Patch install.ini for installid
DIP_HOME="${DATA_DIR}" "${DATA_DIR}/bin/python" /opt/dataiku/installdir/scripts/dkuinstall/install_config.py -set general installid "apideployer-k8s-$DKU_APIDEPLOYER_K8S_NAME"

# Regenerate config to take install.ini into account
DKU_DSSADMIN_NO_CHMOD_SUPERVISORD=1 "${DATA_DIR}/bin/dssadmin" regenerate-config

# Open the local-only non-authenticated metrics server for advanced autoscaling
export DKU_APINODE_LOCAL_METRICS_PORT=13000

# Then run DSS in the foreground

echo "************ STARTING ************************"
set +e
"${DATA_DIR}/bin/dss" run
RETCODE=$?
echo "DSS Stopped ! With return code $RETCODE. Probably apimain crashed"
echo "apimain log:"
echo "------------"
cat "$DATA_DIR/run/apimain.log"

echo "DSS stopped with code $RETCODE" > /dev/termination-log
