import os

import dataiku

from tensorflow.keras.applications import ResNet50
from tensorflow.keras.layers import Dense, Reshape, Input
from tensorflow.keras.models import Model
from numpy import multiply

def build_model(input_shapes, n_classes=None):

    ### DEFINE INPUT AND BASE ARCHITECTURE
    # You need to modify the name and shape of the "image_input" 
    # according to the preprocessing and name of your 
    # initial feature.
    # This feature should be preprocessed as an "Image" with a
    # custom preprocessing.
    image_shape = (197, 197, 3)
    image_input_name = "name_of_your_image_input_preprocessed"
    image_input = Input(shape=image_shape, name=image_input_name)

    # Weights (98 MB) will be downloaded and cached the first time the model is trained
    base_model = ResNet50(include_top=False, input_tensor=image_input)

    ### ADD FULLY CONNECTED CLASSIFICATION LAYER
    x = base_model.layers[-1].output
    x = Reshape((multiply.reduce(x.shape[1:]),))(x)
    predictions = Dense(n_classes, activation="softmax")(x)

    model = Model(inputs=base_model.input, outputs=predictions)
    return model

def compile_model(model):
    model.compile(
        optimizer="adam",
        loss="categorical_crossentropy"
    )
    return model
