import dataiku
import mlflow

client = dataiku.api_client()
project = client.get_project(dataiku.default_project_key())
mlflow_extension = project.get_mlflow_extension()

# Setup mlflow integration, storing artefacts in managed folder. Managed folder must already exist.
mlflow_handle = project.setup_mlflow('A_MANAGED_FOLDER_ID')

# MLflow run and experiment will be sent to DSS backend.
mlflow.set_experiment("my_experiment")

with mlflow.start_run(run_name="my_run") as run:
    # ...your MLflow code...

    # Setting information to make the deployment of a model trained in this run easier through the GUI
    mlflow_extension.set_run_inference_info(run._info.run_id, "MULTICLASS", [...list of classes...],
                                            "code_environment_name", "target_name")
mlflow_handle.clear()
