-- some artifacts indices
CREATE INDEX artifact_blueprint_version_id_index ON artifacts (artifact_blueprint_id, artifact_version_id);
CREATE INDEX artifact_archived_blueprint_version_id_index ON artifacts ((artifact_json #>> '{status, archived}'), artifact_blueprint_id, artifact_version_id);

-- artifact history
CREATE INDEX artifact_history_archived_index ON artifacts_history ((artifact_json #>> '{status, archived}'));
CREATE INDEX artifact_history_step_id_index ON artifacts_history ((artifact_json #>> '{status, stepId}'));
CREATE INDEX artifact_history_dataiku_node_id_index ON artifacts_history ((artifact_json #>> '{fields, node_id}'));
CREATE INDEX artifact_history_dataiku_project_key_index ON artifacts_history ((artifact_json #>> '{fields, project_key}'));
CREATE INDEX artifact_history_dataiku_node_id_project_key_index ON artifacts_history ((artifact_json #>> '{fields, node_id}'), (artifact_json #> '{fields, project_key}'));
CREATE INDEX artifact_history_dataiku_governed_by_index ON artifacts_history ((artifact_json #>> '{fields, governed_by}'));
CREATE INDEX artifact_history_dataiku_hidden_index ON artifacts_history ((artifact_json #>> '{fields, hidden_in_governable_items_table}'));
CREATE INDEX artifact_history_blueprint_version_id_index ON artifacts_history (artifact_blueprint_id, artifact_version_id);
CREATE INDEX artifact_history_archived_blueprint_version_id_index ON artifacts_history ((artifact_json #>> '{status, archived}'), artifact_blueprint_id, artifact_version_id);
