<#
.SYNOPSIS
    Creates a new Python virtual environment for Dataiku Science Studio.
.DESCRIPTION
    Creates a new Python virtual environment for Dataiku Science Studio.
    Usage: _create-virtual.ps1 PYTHONBIN VIRTUALENV_ARG ...
#>
# We can't use 'Param' in this script because we don't want PowerShell to parse arguments starting with hyphens '-'
# Combinations to test:
# Python > 3.6 with no target
# Python > 3.6 with target > 3.6
# Python > 3.6 with target == 3.6, 3.5, 2.7
# Python == 3.6 with no target
# Python == 3.6 with target > 3.6
# Python == 3.6 with target == 3.6, 3.5, 2.7

# Version of the python binary
function GetPythonVersion()
{
    param(
        [Parameter(Mandatory=$true)] [string] $PythonBin
    )

    & $PythonBin -c "import sysconfig;print(sysconfig.get_python_version())"
}

if ($args.count -le 1)
{
    throw "PythonBin is required. Usage: $PSCommandPath PYTHONBIN [-p TARGET_PYTHONBIN] VIRTUALENV_ARG ..."
}

$PythonBin, $remainingArgs = $args

$PythonVersion = GetPythonVersion -PythonBin $PythonBin

if ($remainingArgs[0] -eq "-p") {
    # We can't rely on the targeted Python being in the path to get its version,
    # so we just extract it, and hope for the best.
    $StandardPythonVersion = $remainingArgs[1] -match '^python(?<version>\d+\.\d+)$'
    if ($StandardPythonVersion) {
        $TargetVersion = $Matches.version
    } else {
        $TargetVersion = GetPythonVersion -PythonBin $remainingArgs[1]
    }
} else {
    $TargetVersion = $PythonVersion
}

if ($PythonVersion -eq "3.6") {
    $VirtualEnv = "$PSScriptRoot/virtualenv-20.17.pyz"
} elseif ($TargetVersion -eq "2.7" -or $TargetVersion -eq "3.5" -or $TargetVersion -eq "3.6") {
    $VirtualEnv = "$PSScriptRoot/virtualenv-20.21.pyz"
} else {
    $VirtualEnv = "$PSScriptRoot/virtualenv.pyz"
}

& $PythonBin $VirtualEnv $remainingArgs
