/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dashboards.insights.InsightsRegistry;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.insights.staticfile.StaticFileInsightMeta;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.InsightParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/insights"})
public class PublicAPIInsightsController
extends PublicAPIControllerBase {
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private UsersService usersService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.publicapi.insights");

    @AuditedCall(value={"msgType", "insights-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<InsightListItem> list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            ArrayList<InsightListItem> result = new ArrayList<InsightListItem>();
            for (Insight insight : this.insightsService.listUnsafeVisible(authCtx, projectKey)) {
                InsightListItem listItem = new InsightListItem(insight);
                UsersService.UIUser owner = this.usersService.getUserOrNull_NoLeak(listItem.owner);
                listItem.ownerDisplayName = owner != null ? owner.displayName : null;
                this.taggableObjectsService.setEditionInfoFromTags((TaggableObjectsService.TaggableObject)insight, (TaggableObjectsService.TaggableListItem)listItem);
                result.add(listItem);
            }
            ArrayList<InsightListItem> arrayList = result;
            return arrayList;
        }
    }

    @AuditedCall(value={"msgType", "insight-get", "insightId", "${insightId}"})
    @RequestMapping(value={"/{insightId:.+}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String insightId) throws Exception {
        Insight insight;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            insight = this.insightsService.getMandatoryUnsafe(projectKey, insightId);
        }
        PublicAPIInsightsController.writeJSON((HttpServletResponse)resp, (Object)insight);
    }

    @AuditedCall(value={"msgType", "insight-delete", "projectKey", "${projectKey}", "insightId", "${insightId}"})
    @RequestMapping(value={"/{insightId:.+}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String insightId) throws Exception {
        String commitMessage = "Deleted insight " + projectKey + "." + insightId;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.insightsService.delete(projectKey, insightId);
            t.commit(commitMessage);
        }
        this.writeMessage(resp, commitMessage, new Object[0]);
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        InsightCreationInfo ip = (InsightCreationInfo)this.getRequestBodyAs(req, InsightCreationInfo.class);
        if (ip.insightPrototype == null) {
            throw new IllegalArgumentException("No insight provided");
        }
        Insight insight = ip.insightPrototype;
        insight.projectKey = projectKey;
        insight.id = null;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            if (insight.params == null) {
                insight.params = (InsightParams)InsightsRegistry.getMeta((Insight)insight).paramsClass().newInstance();
            }
            if ("static_file".equals(insight.type)) {
                if (StringUtils.isBlank((String)ip.contentType)) {
                    // empty if block
                }
                StaticFileInsightMeta.StaticFileInsightHandler sih = new StaticFileInsightMeta.StaticFileInsightHandler(insight);
                StaticFileInsightMeta.StaticFileInsightParams params = (StaticFileInsightMeta.StaticFileInsightParams)insight.getParamsAs(StaticFileInsightMeta.StaticFileInsightParams.class);
                params.contentType = ip.contentType;
                params.filetype = sih.getGenericType();
            }
            this.insightsService.setIdAndOwnerOnNewInsight(insight, authCtx);
            this.insightsService.save(insight, true, ip.payload);
            PublicAPIInsightsController.writeJSON((HttpServletResponse)resp, (Object)new Id(insight.id));
            t.commit(String.format("Saved insight %s (%s.%s)", insight.name, projectKey, insight.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            this.auditTrailService.generic("insight-create").with("projectKey", projectKey).with("insightId", insight.id).with("insightName", insight.name).emit();
        }
    }

    @AuditedCall(value={"msgType", "insight-save", "projectKey", "${projectKey}", "insightId", "${insightId}"})
    @RequestMapping(value={"/{insightId:.+}"}, method={RequestMethod.POST})
    public void update(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String insightId) throws Exception {
        InsightWithPayload ip = (InsightWithPayload)this.getRequestBodyAs(req, InsightWithPayload.class);
        if (ip.insight == null) {
            throw new IllegalArgumentException("No insight provided");
        }
        Insight insight = ip.insight;
        insight.projectKey = projectKey;
        insight.id = insightId;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
            if (sp.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY) {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            } else {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS});
            }
            if ("static_file".equals(insight.type) && StringUtils.isNotBlank((String)ip.contentType)) {
                StaticFileInsightMeta.StaticFileInsightParams params = (StaticFileInsightMeta.StaticFileInsightParams)insight.getParamsAs(StaticFileInsightMeta.StaticFileInsightParams.class);
                StaticFileInsightMeta.StaticFileInsightHandler sih = new StaticFileInsightMeta.StaticFileInsightHandler(insight);
                params.contentType = ip.contentType;
                params.filetype = sih.getGenericType();
            }
            Insight existing = this.insightsService.getMandatoryUnsafe(projectKey, insightId);
            if (!StringUtils.equals((String)existing.owner, (String)authCtx.getIdentifier()) && sp.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY) {
                this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS});
            }
            if (!StringUtils.equals((String)existing.owner, (String)insight.owner)) {
                this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
            }
            if (existing.listed != insight.listed && sp.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY) {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS});
            }
            this.insightsService.save(insight, false, ip.payload);
            PublicAPIInsightsController.writeJSON((HttpServletResponse)resp, (Object)new Id(insightId));
            t.commit(String.format("Saved insight %s (%s.%s)", insight.name, projectKey, insightId), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
        }
    }

    public static class InsightListItem
    extends TaggableObjectsService.TaggableListItem {
        public final String type;
        public final String owner;
        public String ownerDisplayName;
        public final boolean listed;

        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.INSIGHT;
        }

        public InsightListItem(Insight insight) {
            super((TaggableObjectsService.TaggableObject)insight);
            this.type = insight.type;
            this.owner = insight.owner;
            this.listed = insight.listed;
        }
    }

    static class InsightCreationInfo {
        Insight insightPrototype;
        String contentType;
        String payload;

        InsightCreationInfo() {
        }
    }

    static class InsightWithPayload {
        Insight insight;
        String contentType;
        String payload;

        InsightWithPayload() {
        }
    }
}

