/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.distributed.workers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.analysis.ml.distributed.workers.AbstractWorkerService;
import com.dataiku.dip.analysis.ml.distributed.workers.Worker;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.io.LambdaGlobalCachePythonKernel;
import com.dataiku.lambda.io.LambdaSimplePythonKernel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class LambdaWorkerService
extends AbstractWorkerService {
    private static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.lambda.distributed.workers");

    public LambdaWorkerService() {
        if (ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.API) {
            throw new UnsupportedOperationException("This worker service is only supported on the API node.");
        }
    }

    public synchronized WorkerPool createWorkerPool(ServiceGenContext ctx, String endpointId, List<String> userCodePaths) {
        ComputeResourceUsageContext cruContext = CurrentComputeResourceUsageContext.get();
        String workerPoolId = this.generateId();
        Runnable unregisterPool = this.getCloseCallBack(workerPoolId);
        WorkerPool workerPool = this.createWorkerPoolInstance(ctx, endpointId, cruContext, workerPoolId, unregisterPool, userCodePaths);
        this.workerPools.put(workerPoolId, workerPool);
        logger.info((Object)("New lambda worker pool created: " + workerPoolId));
        return workerPool;
    }

    public synchronized WorkerPool createGlobalCodeEnvCacheWorkerPool(List<String> userCodePaths) {
        ComputeResourceUsageContext cruContext = CurrentComputeResourceUsageContext.get();
        String workerPoolId = this.generateId();
        Runnable unregisterPool = this.getCloseCallBack(workerPoolId);
        WorkerPool workerPool = this.createWorkerPoolInstance(cruContext, workerPoolId, unregisterPool, userCodePaths);
        this.workerPools.put(workerPoolId, workerPool);
        logger.info((Object)("New lambda worker pool created: " + workerPoolId));
        return workerPool;
    }

    private WorkerPool createWorkerPoolInstance(ComputeResourceUsageContext cruContext, String workerPoolId, Runnable unregisterPool, List<String> userCodePaths) {
        return new WorkerPool("__DKU_PLACEHOLDER_APINODE_PROJECTKEY__", null, (AuthCtx)DSSAuthCtx.newNone(), workerPoolId, cruContext, null, null, unregisterPool, (workerId, workerPool) -> new Worker(workerId, workerPool, (SimplePythonKernel)new LambdaGlobalCachePythonKernel(workerPool.envName, "dataiku.doctor.distributed.remote_worker_server", userCodePaths)), false);
    }

    private WorkerPool createWorkerPoolInstance(ServiceGenContext ctx, String endpointId, ComputeResourceUsageContext cruContext, String workerPoolId, Runnable unregisterPool, List<String> userCodePaths) {
        return new WorkerPool("__DKU_PLACEHOLDER_APINODE_PROJECTKEY__", null, (AuthCtx)DSSAuthCtx.newNone(), workerPoolId, cruContext, null, null, unregisterPool, (workerId, workerPool) -> new Worker(workerId, workerPool, LambdaWorkerService.createPythonKernel(workerPool, ctx, endpointId, userCodePaths)), false);
    }

    private static SimplePythonKernel createPythonKernel(WorkerPool workerPool, ServiceGenContext ctx, String endpointId, List<String> userCodePaths) throws IOException {
        if (!FeatureFlags.isEnabled((String)"apinode_codeenvs_global_cache")) {
            logger.info((Object)"Global cache is enabled.");
            return new LambdaGlobalCachePythonKernel(workerPool.envName, "dataiku.doctor.distributed.remote_worker_server", userCodePaths);
        }
        File codeEnvPath = DKUFileUtils.getWithin((File)new File(System.getenv("DKU_LAMBDA_HOME")), (String[])new String[]{"services", ctx.getServiceId(), "gens", ctx.getGenerationId(), "endpoint-" + endpointId, workerPool.envName, "env"});
        return new LambdaSimplePythonKernel("dataiku.doctor.distributed.remote_worker_server", ctx, endpointId, false, null, userCodePaths, codeEnvPath);
    }

    public synchronized WorkerPool getWorkerPool(String workerPoolId) {
        return super.getWorkerPool(workerPoolId);
    }
}

