/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.directory;

import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.utils.DKULogger;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class NodeConnection {
    @Nullable
    public final String automationNodeId;
    public final String url;
    public final String externalUrl;
    @Nullable
    public final String adminAPIKey;
    public final boolean trustAllSSLCertificates;
    @Nullable
    public final NodesDirectory.NodeStatus nodeDirectoryStatus;
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.NodeConnection");

    public NodeConnection(String automationNodeId, String url, String externalUrl, String adminAPIKey, boolean trustAllSSLCertificates, NodesDirectory.NodeStatus nodeDirectoryStatus) {
        this.automationNodeId = automationNodeId;
        this.url = url;
        this.externalUrl = StringUtils.isBlank((String)externalUrl) ? url : externalUrl;
        this.adminAPIKey = adminAPIKey;
        this.trustAllSSLCertificates = trustAllSSLCertificates;
        this.nodeDirectoryStatus = nodeDirectoryStatus;
    }

    public static NodeConnection forMultiNodeInfra(@Nonnull String automationNodeId, String url, String externalUrl, String adminAPIKey, boolean trustAllSSLCertificates, @Nullable NodesDirectory.NodeStatus nodeDirectoryStatus) {
        return new NodeConnection(automationNodeId, url, externalUrl, adminAPIKey, trustAllSSLCertificates, nodeDirectoryStatus);
    }

    public static NodeConnection forSingleNodeInfra(String url, String externalUrl, String adminAPIKey, boolean trustAllSSLCertificates, @Nullable NodesDirectory.NodeStatus nodeDirectoryStatus) {
        return new NodeConnection(null, url, externalUrl, adminAPIKey, trustAllSSLCertificates, nodeDirectoryStatus);
    }

    public String getUrlWithIdIfExists() {
        if (this.automationNodeId == null) {
            return this.url;
        }
        return String.format("%s with id %s", this.url, this.automationNodeId);
    }

    public String getExternalUrlWithIdIfExists() {
        if (this.automationNodeId == null) {
            return this.externalUrl;
        }
        return String.format("%s with id %s", this.externalUrl, this.automationNodeId);
    }

    public boolean canOpenClient() {
        if (this.nodeDirectoryStatus != null && !Objects.equals((Object)NodesDirectory.NodeStatus.RUNNING, (Object)this.nodeDirectoryStatus) && !Objects.equals((Object)NodesDirectory.NodeStatus.NOT_RESPONDING, (Object)this.nodeDirectoryStatus)) {
            return false;
        }
        if (StringUtils.isBlank((String)this.adminAPIKey)) {
            logger.errorV("The admin key of the node connection for node url %s is blank.", new Object[]{this.url});
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeConnection that = (NodeConnection)o;
        return this.trustAllSSLCertificates == that.trustAllSSLCertificates && Objects.equals((Object)this.nodeDirectoryStatus, (Object)that.nodeDirectoryStatus) && Objects.equals(this.automationNodeId, that.automationNodeId) && Objects.equals(this.url, that.url) && Objects.equals(this.externalUrl, that.externalUrl) && Objects.equals(this.adminAPIKey, that.adminAPIKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.automationNodeId, this.url, this.externalUrl, this.adminAPIKey, this.trustAllSSLCertificates, this.nodeDirectoryStatus});
    }
}

