/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;

public class ModelVersioning {
    public static final int CURRENT_PYMEM_COMPATIBILITY_VERSION = 18;
    public static final int MIN_PYMEM_COMPATIBILITY_VERSION = 18;
    public static final int CURRENT_MLLIB_COMPATIBILITY_VERSION = 1;
    public static final int MIN_MLLIB_COMPATIBILITY_VERSION = 1;
    public static final int CURRENT_H2O_COMPATIBILITY_VERSION = 1;
    public static final int MIN_H2O_COMPATIBILITY_VERSION = 1;
    public static final int CURRENT_VERTICA_COMPATIBILITY_VERSION = 1;
    public static final int MIN_VERTICA_COMPATIBILITY_VERSION = 1;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.ml.versioning");

    public static void dumpTrainVersionInfo(MLTask.BackendType backendType, File modelFolder) throws IOException {
        ModelTrainVersionInfo mtvi = new ModelTrainVersionInfo();
        DKUApp.DSSVersion dssVersion = ApplicationConfigurator.getDSSVersion();
        mtvi.trainedWithDSSVersion = dssVersion.product_version;
        mtvi.trainedWithDSSConfVersion = dssVersion.conf_version;
        mtvi.trainedWithDSSBackend = backendType;
        switch (backendType) {
            case PY_MEMORY: {
                mtvi.backendCompatibilityVersion = 18;
                break;
            }
            case KERAS: {
                mtvi.backendCompatibilityVersion = 18;
                break;
            }
            case MLLIB: {
                mtvi.backendCompatibilityVersion = 1;
                break;
            }
            case H2O: {
                mtvi.backendCompatibilityVersion = 1;
            }
        }
        logger.info((Object)("Dumping version info " + JSON.json((Object)mtvi) + " in " + String.valueOf(modelFolder)));
        JSON.prettyToFile((Object)mtvi, (File)new File(modelFolder, "version_info.json"));
    }

    public static class ModelTrainVersionInfo {
        public String trainedWithDSSVersion;
        public String trainedWithDSSConfVersion;
        public MLTask.BackendType trainedWithDSSBackend;
        public int backendCompatibilityVersion;
    }
}

