/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.guess;

import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnalyseUtils {
    public static List<String> getValuesPresentMoreThan(MemTable table, MemColumn col, int min) {
        HashMap<String, Integer> bag = new HashMap<String, Integer>();
        for (int i = 0; i < table.nrows(); ++i) {
            String v = table.rows.get(i).get(col);
            Integer cur = (Integer)bag.get(v);
            if (cur == null) {
                cur = 0;
            }
            Integer n = cur;
            cur = cur + 1;
            bag.put(v, cur);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry e : bag.entrySet()) {
            if ((Integer)e.getValue() < min) continue;
            list.add((String)e.getKey());
        }
        return list;
    }

    public static Map<String, Integer> getValueFreqs(MemTable table, MemColumn col) {
        HashMap<String, Integer> bag = new HashMap<String, Integer>();
        for (int i = 0; i < table.nrows(); ++i) {
            String v;
            MemRow row = table.rows.get(i);
            if (row.isDeleted() || (v = row.get(col)) == null) continue;
            Integer cur = (Integer)bag.get(v);
            if (cur == null) {
                cur = 0;
            }
            Integer n = cur;
            cur = cur + 1;
            bag.put(v, cur);
        }
        return bag;
    }

    public static List<TermFreq> getValueFreqs2(MemTable table, MemColumn col) {
        ArrayList<TermFreq> ret = new ArrayList<TermFreq>();
        for (Map.Entry<String, Integer> e : AnalyseUtils.getValueFreqs(table, col).entrySet()) {
            ret.add(new TermFreq(e.getKey(), e.getValue()));
        }
        return ret;
    }

    public static class TermFreq {
        public String val;
        public int freq;

        public TermFreq(String val, int freq) {
            this.val = val;
            this.freq = freq;
        }
    }
}

