/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.apideployer.infra.ApiNodeStaticInfraManager;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class StaticAPIDeploymentInfra
extends AbstractAPIDeploymentInfra {
    private boolean trustAllSSLCertificates;
    public List<APINodeRef> apiNodes = new ArrayList<APINodeRef>();
    public StaticAPINodeLogging defaultApiNodeLogging = new StaticAPINodeLogging();
    public HealthSettings defaultHealthSettings = new HealthSettings();
    public RollingUpdateSettings defaultRollingUpdateSettings = new RollingUpdateSettings();

    private StaticAPIDeploymentInfra() {
    }

    public StaticAPIDeploymentInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
    }

    @Override
    public boolean shouldTrustAllCertificates() {
        return this.trustAllSSLCertificates;
    }

    @Override
    @Nonnull
    public AbstractAPIDeploymentInfra.APINodeLogging getNodeLogging() {
        return this.defaultApiNodeLogging;
    }

    @Override
    public AbstractDeploymentInfra.InfraType getInfraType() {
        return AbstractDeploymentInfra.InfraType.STATIC;
    }

    @Override
    public ApiNodeInfraManager getInfraManager(DKULogger logger) {
        return new ApiNodeStaticInfraManager(this, logger);
    }

    @Override
    public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
        super.encryptFields(passwordEncryptionService);
        this.apiNodes.forEach(apiNode -> apiNode.encryptFields(passwordEncryptionService));
    }

    public static class StaticAPINodeLogging
    extends AbstractAPIDeploymentInfra.APINodeLogging {
    }

    public static class HealthSettings {
        public int maxFailing = 1;
    }

    public static class RollingUpdateSettings {
        public boolean waitLoadBalancerTimeout;
        public int loadBalancerTimeoutMS = 10000;
    }

    public static class APINodeRef {
        public String url;
        public String externalUrl;
        public String adminAPIKey;
        public String graphitePrefix;

        public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
            this.adminAPIKey = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(this.adminAPIKey);
        }
    }
}

