/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockParams;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CustomActionBlockMeta
implements CodeStudioBlockMeta {
    @Override
    public String getType() {
        return "custom_action";
    }

    @Override
    public void newTemplateInitialization(CodeStudioBlock block) {
    }

    @Override
    public Class<? extends CodeStudioBlockParams> blockParamsClass() {
        return CustomActionParams.class;
    }

    @Override
    public CodeStudioBlock.CodeStudioBlockType getBlockType() {
        CodeStudioBlock.CodeStudioBlockType ret = new CodeStudioBlock.CodeStudioBlockType();
        ret.type = this.getType();
        ret.label = "Add Custom Action";
        ret.description = "Add a custom action to your Code Studio";
        ret.isLocked = false;
        ret.isUnique = false;
        ret.icon = "icon-play";
        ret.isAdvanced = true;
        ret.uiDisplayPriority = 1040;
        return ret;
    }

    @Override
    public CodeStudioMeta.ImageBuildSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.ImageBuildSpec buildSpec, CodeStudioMeta.ImageBuildEnv buildEnv, CodeStudioTemplate template) throws IOException {
        return buildSpec;
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CodeStudioLaunchSpec launchSpec, CodeStudioMeta.CodeStudioLaunchEnv launchEnv) throws IOException {
        CustomActionParams params = block.getParamsAs(CustomActionParams.class);
        CodeStudioMeta.CodeStudioCustomCommand cmd = new CodeStudioMeta.CodeStudioCustomCommand();
        cmd.name = params.actionName;
        cmd.label = StringUtils.defaultIfBlank((String)params.actionLabel, (String)params.actionName);
        cmd.command = params.actionCommand;
        cmd.behavior = params.actionBehavior;
        cmd.icon = params.actionIcon;
        cmd.description = params.actionDescription;
        launchSpec.customCommands.add(cmd);
        return launchSpec;
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportBlock(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.TemplateExportSpec exportSpec) {
        return exportSpec;
    }

    @Override
    public CodeStudioBlock importBlock(AuthCtx authCtx, CodeStudioBlock srcBlock, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) {
        return srcBlock;
    }

    @Override
    public CodeStudioMeta.CreationSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CreationSpec creationSpec, CodeStudioMeta.CreationEnv creationEnv) throws IOException, DKUSecurityException {
        return creationSpec;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioBlock block, CodeStudioTemplate template) {
        return Lists.newArrayList();
    }

    public static class CustomActionParams
    implements CodeStudioBlockParams {
        String actionName;
        String actionLabel;
        String actionCommand;
        String actionIcon;
        String actionDescription;
        public CodeStudioMeta.CodeStudioCommandBehavior actionBehavior = CodeStudioMeta.CodeStudioCommandBehavior.FIRE_AND_FORGET;

        @Override
        public void checkValid(VariablesContext templateVariablesContext) throws Exception {
            if (StringUtils.isEmpty((String)this.actionName)) {
                throw ErrorContext.ice((String)"Action name must not be empty.");
            }
            if (StringUtils.isEmpty((String)this.actionCommand)) {
                throw ErrorContext.ice((String)"Action command must not be empty.");
            }
        }
    }
}

