/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.SharePointOnlineFSProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.UrlRedactionUtils;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.authentication.IAuthenticationProvider;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.content.BatchRequestContent;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.content.BatchResponseContent;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.content.BatchResponseStep;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.HttpMethod;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.IHttpRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.httpcore.HttpClients;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.ColumnDefinition;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.DateTimeColumn;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.Drive;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.DriveItem;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.DriveItemCheckinParameterSet;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.DriveItemCopyParameterSet;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.DriveItemCreateUploadSessionParameterSet;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.DriveItemUploadableProperties;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.ItemReference;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.List;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.ListInfo;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.ListItem;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.NumberColumn;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.Site;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.TextColumn;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.UploadSession;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.options.Option;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.options.QueryOption;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ColumnDefinitionCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ColumnDefinitionCollectionRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.DriveCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.DriveCollectionRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.DriveCollectionRequestBuilder;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.DriveItemCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.DriveItemCollectionRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.GraphServiceClient;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.GroupRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ListCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ListCollectionRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ListCollectionRequestBuilder;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ListItemCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ListItemCollectionRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ListItemCollectionRequestBuilder;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ListItemRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.PermissionCollectionRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.SiteCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.SiteCollectionRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.SiteCollectionRequestBuilder;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.SiteRequestBuilder;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.tasks.IProgressCallback;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.tasks.IUploadSession;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.tasks.LargeFileUploadResult;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.tasks.LargeFileUploadTask;
import com.dataiku.dss.shadelibazure.okhttp3.OkHttpClient;
import com.dataiku.dss.shadelibazure.okhttp3.Request;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.StringUtils;

public class SharePointOnlineConnection
extends DSSConnection
implements ConnectionWithEncryptedFields,
ConnectionWithPerUserOAuth2Credentials,
FSProviderizableConnection,
ConnectionWithBasicCredential {
    private static final int SHAREPOINT_CONNECT_TIMEOUT_MILLIS = 10000;
    private static final int SHAREPOINT_READ_TIMEOUT_MILLIS = 10000;
    private static final int SHAREPOINT_WRITE_TIMEOUT_MILLIS = 10000;
    public static final String connectionType = "SharePointOnline";
    public SharePointOnlineParams params = new SharePointOnlineParams();
    private static final Map<String, OAuth2Client.AccessTokenResult> tokenCache = Maps.newHashMap();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sharepointonline");

    @Override
    public String getType() {
        return connectionType;
    }

    public Params getDkuPropertiesAsParams() {
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.getDkuProperties());
    }

    public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, boolean useCachedAccessToken) throws DKUSecurityException {
        String authorizationEndpoint = this.params.authorizationEndpoint;
        String tokenEndpoint = this.params.tokenEndpoint;
        String scopes = this.params.scopes;
        logger.info((Object)("Using OAuth2 authorize endpoint: " + authorizationEndpoint));
        logger.info((Object)("Using OAuth2 token endpoint: " + tokenEndpoint));
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        OAuth2Client.Builder builder = new OAuth2Client.Builder().authorizationEndpoint(authorizationEndpoint).tokenEndpoint(tokenEndpoint).clientId(this.params.appId).scope(scopes).usePkce(true).proxy(proxySettings).useAccessTokenCache(useCache && useCachedAccessToken);
        if (this.params.authType == AuthType.OAUTH2_APP && StringUtils.isNotEmpty((String)this.params.appSecret)) {
            builder.clientSecret(this.params.appSecret);
        } else if (this.params.authType == AuthType.KEYPAIR) {
            builder.certificate(this.params.thumbprint, this.params.privateKey);
        }
        return builder.build();
    }

    private static String makeTokenKey(SharePointOnlineParams params, String scope) {
        logger.info((Object)("Using access token cache key: '" + params.appId + " [client secret] ' " + scope + " (global)"));
        return params.appId + " " + params.appSecret + " " + scope;
    }

    @Override
    public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        return this.buildOAuth2Client(proxySettings, true);
    }

    @Override
    public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAccessToken(authCtx, this.getProxySettings()).getAccessToken());
    }

    private OAuth2Client.AccessTokenResult getAccessToken(AuthCtx authCtx, ProxySettings proxySettings) {
        logger.infoV("Getting an access token for authorization type: %s", new Object[]{this.params.authType});
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.decryptFields(cryptoService);
        try {
            OAuth2Client oauth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
            if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                switch (this.params.authType) {
                    case PASSWORD: {
                        return this.getAccessTokenFromFromResourceOwnerPassword(authCtx, oauth2Client, false);
                    }
                }
                return this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oauth2Client, false);
            }
            switch (this.params.authType) {
                case PASSWORD: {
                    return this.getAccessTokenFromFromResourceOwnerPassword(authCtx, oauth2Client, false);
                }
            }
            return oauth2Client.acquireAccessTokenResultWithClientCredentialsGrant(useCache);
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
        }
    }

    private String getUserCredentialRefreshToken(AuthCtx authCtx) {
        ICredentialsService ics = (ICredentialsService)SpringUtils.getBean(ICredentialsService.class);
        try {
            return ((ICredentialsService.OAuthRefreshTokenCredential)ics.getDecryptedCredential_AutoTXN((AuthCtx)authCtx, (DSSConnection)this)).refreshToken;
        }
        catch (IOException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 refresh token from user's credentials", (Throwable)e);
        }
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.tenantId = vc.expand(this.params.tenantId);
        this.params.appId = vc.expand(this.params.appId);
        this.params.appSecret = vc.expand(this.params.appSecret);
        this.params.username = vc.expand(this.params.username);
        this.params.password = vc.expand(this.params.password);
        this.params.privateKey = vc.expand(this.params.privateKey);
        this.params.thumbprint = vc.expand(this.params.thumbprint);
        this.params.authorizationEndpoint = vc.expand(this.params.authorizationEndpoint);
        this.params.tokenEndpoint = vc.expand(this.params.tokenEndpoint);
        this.params.scopes = vc.expand(this.params.scopes);
        this.params.defaultManagedSite = vc.expand(this.params.defaultManagedSite);
        this.params.defaultManagedDrive = vc.expand(this.params.defaultManagedDrive);
        this.params.defaultManagedPath = vc.expand(this.params.defaultManagedPath);
    }

    @Override
    public java.util.List<String> getProviderTypes() {
        return Lists.newArrayList((Object[])new String[]{connectionType});
    }

    @Override
    public boolean allowManagedFolders() {
        return false;
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.appSecret = cryptoService.decryptIfEncrypted(this.params.appSecret);
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.privateKey = cryptoService.decryptIfEncrypted(this.params.privateKey);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.appSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.appSecret);
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.params.privateKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.privateKey);
    }

    @Override
    public java.util.List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    public SharePointOnlineClient getSharePointOnlineClient(AuthCtx authCtx, ProxySettings proxySettings) {
        return new SharePointOnlineClient(authCtx, proxySettings);
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && (this.params.authType == AuthType.OAUTH2_APP || this.params.authType == AuthType.KEYPAIR);
    }

    @Override
    public boolean hasRefreshTokenRotation() {
        return false;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testSharePointOnline(this, authCtx);
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableSharePointCredentials.class));
        SerializableSharePointCredentials creds = new SerializableSharePointCredentials();
        creds.authType = this.params.authType;
        switch (creds.authType) {
            case PASSWORD: {
                ICredentialsService.BasicCredential basicCreds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(this, ctx.authCtx);
                creds.user = basicCreds.user;
                creds.password = basicCreds.password;
            }
            case KEYPAIR: 
            case OAUTH2_APP: {
                creds.privateKey = this.params.privateKey;
                creds.thumbprint = this.params.thumbprint;
                creds.oauth2AppId = this.params.appId;
                creds.oauth2AppSecret = this.params.appSecret;
                creds.oauth2Scope = this.params.scopes;
                creds.oauth2AuthorizationEndpoint = this.params.authorizationEndpoint;
                creds.oauth2TokenEndpoint = this.params.tokenEndpoint;
                OAuth2Client.AccessTokenResult tokens = this.getAccessToken(ctx.authCtx, this.getProxySettings());
                if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                    creds.oauth2RefreshToken = tokens.getRefreshToken();
                }
                creds.oauth2AccessToken = tokens.getAccessToken();
            }
        }
        return clazz.cast(creds);
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.GLOBAL && this.params.authType == AuthType.PASSWORD;
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.username, this.params.password);
    }

    public static class SharePointOnlineParams
    extends DSSConnection.DkuConnectionParams {
        public AuthType authType;
        public String tenantId;
        public String appId;
        public String appSecret;
        public String username;
        public String password;
        public String privateKey;
        public String thumbprint;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String scopes;
        public String defaultManagedSite;
        public String defaultManagedDrive;
        public String defaultManagedPath;
        public java.util.List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public java.util.List<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public FSProviderizableConnection.FilesBasedDatasetNamingRule namingRule = new FSProviderizableConnection.FilesBasedDatasetNamingRule();
    }

    public static enum AuthType {
        OAUTH2_APP,
        PASSWORD,
        KEYPAIR;

    }

    public class SharePointOnlineClient {
        private String userAccessToken;
        private GraphServiceClient<Request> graphClient;
        private BatchRequestContent batchRequestContent = null;
        private Map<String, CallStructure> requestPerId = null;
        private long batchSize = 0L;
        private long maxBatchSize;
        private long maxNumberOfTries;
        private static final long ONE_SECOND = 1000L;
        private static final long BATCH_RETRY_WAITING_TIME = 10000L;

        public SharePointOnlineClient(AuthCtx authCtx, ProxySettings proxySettings) {
            this.maxBatchSize = ApplicationConfigurator.getParams().getLongParam("dip.sharepointonline.max_batch_size", 20L);
            this.maxNumberOfTries = ApplicationConfigurator.getParams().getLongParam("dip.sharepointonline.max_nb_retries", 10L);
            final String accessToken = SharePointOnlineConnection.this.getResolvedOAuth2Credential((AuthCtx)authCtx).accessToken;
            IAuthenticationProvider authProvider = new IAuthenticationProvider(){

                public CompletableFuture<String> getAuthorizationTokenAsync(URL requestUrl) {
                    CompletableFuture<String> future = new CompletableFuture<String>();
                    future.complete(accessToken);
                    return future;
                }
            };
            OkHttpClient okHttpClient = null;
            Params properties = AbstractSQLConnection.CustomDatabaseProperty.toParams(SharePointOnlineConnection.this.params.properties);
            int connectTimeout = properties.getIntParamOrElse("ConnectTimeout", 10000);
            int readTimeout = properties.getIntParamOrElse("ReadTimeout", 10000);
            int writeTimeout = properties.getIntParamOrElse("WriteTimeout", 10000);
            try {
                OkHttpClient.Builder clientBuilder = HttpClients.createDefault((IAuthenticationProvider)authProvider).newBuilder().connectTimeout(Duration.ofMillis(connectTimeout)).readTimeout(Duration.ofMillis(readTimeout)).writeTimeout(Duration.ofMillis(writeTimeout));
                if (proxySettings.hasProxy()) {
                    ProxyUtils.applyToOkHttpClient((ProxySettings)proxySettings, (boolean)true, (OkHttpClient.Builder)clientBuilder);
                }
                okHttpClient = clientBuilder.build();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            this.graphClient = GraphServiceClient.builder().httpClient((Object)okHttpClient).authenticationProvider(authProvider).buildClient();
        }

        @VisibleForTesting
        protected SharePointOnlineClient(GraphServiceClient<Request> graphClient) {
            this.graphClient = graphClient;
        }

        public GraphServiceClient<Request> getGraphClient() {
            return this.graphClient;
        }

        public java.util.List<CustomSite> getSites() throws IOException {
            logger.info((Object)"Listing all available SharePoint sites");
            return this.getSites("*");
        }

        public void pingSitesEndpoint() throws IOException {
            logger.info((Object)"Pinging the SharePoint sites endpoint");
            try {
                java.util.List list = ((SiteCollectionPage)((SiteCollectionRequest)this.graphClient.sites().buildRequest(new Option[0])).get()).getCurrentPage();
                logger.infoV("Reached SharePoint, list size : %s", new Object[]{list.size()});
            }
            catch (Exception e) {
                logger.error((Object)"Couldn't reach SharePoint", (Throwable)e);
                throw new IOException("Couldn't reach SharePoint: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }

        public CustomSite getSiteFromUrl(URL url) throws IOException {
            logger.infoV("Searching SharePoint site named %s", new Object[]{url});
            CustomSite site = null;
            StringBuilder siteName = new StringBuilder();
            try {
                String host = url.getHost();
                String path = url.getPath();
                String[] pathTokens = path.split("/");
                if (pathTokens.length < 2) {
                    logger.infoV("The SharePoint URL does not contain enough segments: %s", new Object[]{pathTokens.length});
                    return site;
                }
                if (pathTokens[pathTokens.length - 1].equalsIgnoreCase("AllItems.aspx")) {
                    for (index = 2; index < pathTokens.length - 3; ++index) {
                        siteName.append(pathTokens[index]).append("/");
                    }
                } else {
                    for (index = 2; index < pathTokens.length; ++index) {
                        siteName.append(pathTokens[index]).append("/");
                    }
                }
                if (siteName.length() == 0) {
                    logger.info((Object)"No site name found");
                    return site;
                }
                if (siteName.length() > 0 && siteName.charAt(siteName.length() - 1) == '/') {
                    siteName.deleteCharAt(siteName.length() - 1);
                }
                logger.infoV("Extracted site name from URL: %s", new Object[]{siteName});
                LinkedList<QueryOption> requestOptions = new LinkedList<QueryOption>();
                requestOptions.add(new QueryOption("$select", (Object)"id"));
                Site siteFound = ((SiteRequestBuilder)this.graphClient.sites().byId(host + ":/" + pathTokens[1] + "/" + siteName.toString())).buildRequest(requestOptions).get();
                if (siteFound.id != null) {
                    site = new CustomSite();
                    site.id = siteFound.id;
                    site.name = siteName.toString();
                    return site;
                }
            }
            catch (Exception e) {
                throw new IOException("No site could be extracted from the URL: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            return site;
        }

        private static URL tryParseURL(String site) {
            try {
                return new URL(site);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        public java.util.List<CustomSite> getSites(String siteName) throws IOException {
            logger.infoV("Listing SharePoint sites named %s. Try URL pattern first", new Object[]{siteName});
            if (StringUtils.isBlank((String)siteName)) {
                return new ArrayList<CustomSite>();
            }
            ArrayList<CustomSite> res = new ArrayList<CustomSite>();
            String siteNameClean = !siteName.isEmpty() && siteName.charAt(siteName.length() - 1) == '*' ? siteName.substring(0, siteName.length() - 1) : siteName;
            URL url = SharePointOnlineClient.tryParseURL(siteNameClean);
            if (url != null) {
                CustomSite matchingSite = this.getSiteFromUrl(url);
                if (matchingSite != null) {
                    res.add(matchingSite);
                    return res;
                }
            } else {
                logger.infoV("Site %s is not an URL, defaulting to site search", new Object[]{siteName});
            }
            LinkedList<QueryOption> requestOptions = new LinkedList<QueryOption>();
            requestOptions.add(new QueryOption("search", (Object)siteName));
            try {
                SiteCollectionRequestBuilder nextPage;
                SiteCollectionPage initialPage = (SiteCollectionPage)((SiteCollectionRequest)this.graphClient.sites().buildRequest(requestOptions)).get();
                do {
                    logger.info((Object)"New sites page");
                    for (Site site : initialPage.getCurrentPage()) {
                        CustomSite item = new CustomSite();
                        item.id = site.id;
                        item.name = site.name;
                        res.add(item);
                    }
                } while ((initialPage = (nextPage = (SiteCollectionRequestBuilder)initialPage.getNextPage()) == null ? null : (SiteCollectionPage)((SiteCollectionRequest)nextPage.buildRequest(new Option[0])).get()) != null);
            }
            catch (Exception e) {
                logger.error((Object)"Couldn't list sites", (Throwable)e);
                throw new IOException("Could not access the site's lists: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            logger.infoV("%d sites found with names matching '%s'", new Object[]{res.size(), siteName});
            return res;
        }

        public String getSiteName(String siteId) {
            logger.infoV("Searching site name from id %s", new Object[]{siteId});
            try {
                Site site = this.graphClient.sites(siteId).buildRequest(new Option[0]).get();
                logger.infoV("Site name is '%s'", new Object[]{site.name});
                return site.name;
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Couldn't get site name for site '%s'", new Object[]{siteId});
                return null;
            }
        }

        public CustomSite getSiteById(String siteId) {
            CustomSite returnSite = new CustomSite();
            logger.infoV("Searching site from id %s", new Object[]{siteId});
            try {
                Site site = this.graphClient.sites(siteId).buildRequest(new Option[0]).get();
                logger.infoV("Site name is '%s'", new Object[]{site.name});
                returnSite.name = site.name;
                returnSite.id = site.id;
                return returnSite;
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Couldn't get site for site id '%s'", new Object[]{siteId});
                return returnSite;
            }
        }

        public String getSiteId(String siteName) throws IOException {
            logger.infoV("Getting site id for '%s'", new Object[]{siteName});
            LinkedList<QueryOption> requestOptions = new LinkedList<QueryOption>();
            requestOptions.add(new QueryOption("search", (Object)siteName));
            try {
                SiteCollectionRequestBuilder nextPage;
                SiteCollectionPage initialPage = (SiteCollectionPage)((SiteCollectionRequest)this.graphClient.sites().buildRequest(requestOptions)).get();
                do {
                    logger.info((Object)"New sites page");
                    for (Site site : initialPage.getCurrentPage()) {
                        if (!StringUtils.equals((String)site.name, (String)siteName)) continue;
                        logger.infoV("Site id of '%s' is %s", new Object[]{siteName, site.id});
                        return site.id;
                    }
                } while ((initialPage = (nextPage = (SiteCollectionRequestBuilder)initialPage.getNextPage()) == null ? null : (SiteCollectionPage)((SiteCollectionRequest)nextPage.buildRequest(new Option[0])).get()) != null);
            }
            catch (Exception e) {
                logger.error((Object)"Couldn't list sites", (Throwable)e);
                throw new IOException("Could not access the site's lists: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            logger.infoV("No site named '%s' was found", new Object[]{siteName});
            return null;
        }

        public String getDriveId(String siteId, String driveName) {
            logger.infoV("Getting drive id for '%s' on site %s", new Object[]{driveName, siteId});
            String driveId = this.getDrives(siteId, driveName).stream().filter(drive -> drive.name.equals(driveName)).findFirst().map(drive -> drive.id).orElse(null);
            logger.infoV("Drive id for '%s' on site %s is %s", new Object[]{driveName, siteId, driveId});
            return driveId;
        }

        public String getDriveName(String siteId, String driveId) {
            logger.infoV("Searching drive name from id %s on site %s", new Object[]{driveId, siteId});
            try {
                Drive drive = this.graphClient.sites(siteId).drives(driveId).buildRequest(new Option[0]).get();
                logger.infoV("Drive name is '%s'", new Object[]{drive.name});
                return drive.name;
            }
            catch (Exception e) {
                logger.error((Object)"Couldn't list sites", (Throwable)e);
                return null;
            }
        }

        public java.util.List<CustomDrive> getDrives(String siteId) {
            return this.getDrives(siteId, null);
        }

        public java.util.List<CustomDrive> getDrives(String siteId, String driveName) {
            if (driveName == null) {
                logger.infoV("Listing all SharePoint drives for site %s", new Object[]{siteId});
            } else {
                logger.infoV("Listing SharePoint drives named '%s' on %s", new Object[]{driveName, siteId});
            }
            ArrayList<CustomDrive> res = new ArrayList<CustomDrive>();
            if (siteId == null || siteId.isEmpty()) {
                logger.info((Object)"Requesting drives from empty site ID");
                return res;
            }
            try {
                DriveCollectionRequestBuilder nextPage;
                DriveCollectionPage initialPage = (DriveCollectionPage)((DriveCollectionRequest)this.graphClient.sites(siteId).drives().buildRequest(new Option[0])).get();
                do {
                    for (Drive drive : initialPage.getCurrentPage()) {
                        CustomDrive item = new CustomDrive();
                        item.id = drive.id;
                        item.name = drive.name;
                        res.add(item);
                        if (driveName == null || !driveName.equals(drive.name)) continue;
                        logger.infoV("Drive '%s' found", new Object[]{driveName});
                        return res;
                    }
                } while ((initialPage = (nextPage = (DriveCollectionRequestBuilder)initialPage.getNextPage()) == null ? null : (DriveCollectionPage)((DriveCollectionRequest)nextPage.buildRequest(new Option[0])).get()) != null);
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "couldn't list drives for siteId %s", new Object[]{siteId});
            }
            logger.infoV("%d drives found on site %s", new Object[]{res.size(), siteId});
            return res;
        }

        public String getListId(String siteId, String listName) throws IOException {
            logger.infoV("Getting lists id for list %s on %s", new Object[]{listName, siteId});
            if (listName == null || listName.isEmpty()) {
                logger.info((Object)"Requesting list with empty name");
                return null;
            }
            if (siteId == null || siteId.isEmpty()) {
                logger.info((Object)"Requesting lists from empty site name");
                return null;
            }
            try {
                ListCollectionRequestBuilder nextPage;
                ListCollectionPage initialPage = (ListCollectionPage)((ListCollectionRequest)this.graphClient.sites(siteId).lists().buildRequest(new Option[0])).get();
                do {
                    for (List sharePointList : initialPage.getCurrentPage()) {
                        if (!StringUtils.equals((String)listName, (String)sharePointList.name)) continue;
                        logger.infoV("Found matching list with id %s", new Object[]{sharePointList.id});
                        return sharePointList.id;
                    }
                } while ((initialPage = (nextPage = (ListCollectionRequestBuilder)initialPage.getNextPage()) == null ? null : (ListCollectionPage)((ListCollectionRequest)nextPage.buildRequest(new Option[0])).get()) != null);
            }
            catch (Exception e) {
                logger.error((Object)"couldn't list the SharePoint lists", (Throwable)e);
                throw new IOException("Error while getting lists: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            logger.infoV("Did not found any list named %s on siteId %s", new Object[]{listName, siteId});
            return null;
        }

        public java.util.List<CustomList> getLists(String siteId) throws IOException {
            logger.infoV("Getting lists for siteId %s", new Object[]{siteId});
            ArrayList<CustomList> lists = new ArrayList<CustomList>();
            if (siteId == null || siteId.isEmpty()) {
                logger.info((Object)"Requesting lists from empty site ID");
                return lists;
            }
            try {
                ListCollectionRequestBuilder nextPage;
                ListCollectionPage initialPage = (ListCollectionPage)((ListCollectionRequest)this.graphClient.sites(siteId).lists().buildRequest(new Option[0])).get();
                do {
                    for (List sharePointList : initialPage.getCurrentPage()) {
                        CustomList list = new CustomList();
                        list.id = sharePointList.id;
                        list.name = sharePointList.name;
                        list.displayName = sharePointList.displayName;
                        lists.add(list);
                    }
                } while ((initialPage = (nextPage = (ListCollectionRequestBuilder)initialPage.getNextPage()) == null ? null : (ListCollectionPage)((ListCollectionRequest)nextPage.buildRequest(new Option[0])).get()) != null);
            }
            catch (Exception e) {
                logger.error((Object)"couldn't list all the SharePoint lists", (Throwable)e);
                throw new IOException("Error while getting lists: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            logger.infoV("Found %s lists for siteId %s", new Object[]{lists.size(), siteId});
            return lists;
        }

        public java.util.List<ColumnDefinition> getAllListColumns(String siteId, String listId) {
            ColumnDefinitionCollectionPage columnsPage = (ColumnDefinitionCollectionPage)((ColumnDefinitionCollectionRequest)this.graphClient.sites(siteId).lists(listId).columns().buildRequest(new Option[0])).get();
            java.util.List columnsList = columnsPage.getCurrentPage();
            return columnsList;
        }

        public void createMissingColumns(String siteId, String listId, java.util.List<SchemaColumn> missingSharePointColumns) {
            for (SchemaColumn missingSharePointColumn : missingSharePointColumns) {
                TextColumn text;
                logger.info((Object)("Creating column " + missingSharePointColumn.getName() + " on list " + listId));
                Type dssType = missingSharePointColumn.getType();
                ColumnDefinition columnDefinition = new ColumnDefinition();
                columnDefinition.description = null;
                columnDefinition.enforceUniqueValues = false;
                columnDefinition.hidden = false;
                columnDefinition.indexed = false;
                columnDefinition.name = missingSharePointColumn.getName();
                if (dssType.isNumeric()) {
                    NumberColumn number;
                    columnDefinition.number = number = new NumberColumn();
                } else if (dssType.isTemporal()) {
                    DateTimeColumn dateTime = new DateTimeColumn();
                    dateTime.format = dssType == Type.DATEONLY ? "dateOnly" : "dateTime";
                    columnDefinition.dateTime = dateTime;
                } else if (dssType.getName() == "string") {
                    text = new TextColumn();
                    text.allowMultipleLines = false;
                    text.appendChangesToExistingText = false;
                    text.linesForEditing = 0;
                    text.maxLength = 255;
                    columnDefinition.text = text;
                } else {
                    text = new TextColumn();
                    text.allowMultipleLines = false;
                    text.appendChangesToExistingText = false;
                    text.linesForEditing = 0;
                    text.maxLength = 255;
                    columnDefinition.text = text;
                }
                try {
                    text = ((ColumnDefinitionCollectionRequest)this.graphClient.sites(siteId).lists(listId).columns().buildRequest(new Option[0])).post(columnDefinition);
                }
                catch (Exception e) {
                    logger.error((Object)("Error while adding column " + missingSharePointColumn.getName()), (Throwable)e);
                }
            }
        }

        public long getListLength(String siteId, String listId) {
            ListItemCollectionRequestBuilder nextPage;
            logger.info((Object)("getListLength for siteId=" + siteId + " listId=" + listId));
            LinkedList<QueryOption> requestOptions = new LinkedList<QueryOption>();
            requestOptions.add(new QueryOption("expand", (Object)"fields(select=ID)"));
            ListItemCollectionPage page = (ListItemCollectionPage)((ListItemCollectionRequest)this.graphClient.sites(siteId).lists(listId).items().buildRequest(requestOptions)).get();
            long listLength = 0L;
            do {
                listLength += (long)page.getCurrentPage().size();
            } while ((page = (nextPage = (ListItemCollectionRequestBuilder)page.getNextPage()) == null ? null : (ListItemCollectionPage)((ListItemCollectionRequest)nextPage.buildRequest(new Option[0])).get()) != null);
            return listLength;
        }

        public ListItem putRow(String siteId, String listId, ListItem row) throws InterruptedException {
            ListItem listItem = null;
            try {
                listItem = ((ListItemCollectionRequest)this.graphClient.sites(siteId).lists(listId).items().buildRequest(new Option[0])).post(row);
            }
            catch (Exception e) {
                logger.error((Object)("Error on putRow " + ExceptionUtils.getMessageWithCauses((Throwable)e)), (Throwable)e);
                logger.debug((Object)("Row content : " + row.toString()));
            }
            return listItem;
        }

        public void batchPutRow(String siteId, String listId, ListItem row) throws Exception {
            ListItemCollectionRequest thisRow = (ListItemCollectionRequest)this.graphClient.sites(siteId).lists(listId).items().buildRequest(new Option[0]);
            this.addItemToBatch((IHttpRequest)thisRow, HttpMethod.POST, row);
        }

        public void flushListRowsAndRetry() throws Exception {
            if (this.batchSize == 0L) {
                return;
            }
            logger.info((Object)("Batch flushing " + this.batchSize + " rows in SharePoint list"));
            boolean tryAgain = true;
            long numberOfTries = 0L;
            while (tryAgain) {
                tryAgain = false;
                try {
                    this.flushBatch();
                }
                catch (Exception e) {
                    if (e.getMessage().contains("Error during http request")) {
                        logger.warn((Object)("Error while flushing the batch: " + ExceptionUtils.getMessageWithCauses((Throwable)e)), (Throwable)e);
                        logger.info((Object)("Batch " + this.batchSize + " items long. Ignoring."));
                        this.batchSize = 0L;
                    }
                    logger.error((Object)("Error while flushing the batch: " + ExceptionUtils.getMessageWithCauses((Throwable)e)), (Throwable)e);
                    logger.info((Object)("Attempt #" + numberOfTries + ". Waiting 10s to retry"));
                    Thread.sleep(10000L);
                }
                if (++numberOfTries >= this.maxNumberOfTries || this.batchSize <= 0L) continue;
                tryAgain = true;
            }
            if (this.batchSize > 0L) {
                logger.error((Object)("There are " + this.batchSize + " rows that could not be uploaded to Sharepoint list"));
                throw new Exception("Could not process the SharePoint list");
            }
            this.batchRequestContent = new BatchRequestContent();
            this.batchSize = 0L;
            this.requestPerId = new HashMap<String, CallStructure>();
        }

        public void addItemToBatch(IHttpRequest listItemRequest, HttpMethod method, ListItem listItem) throws Exception {
            if (this.batchRequestContent == null) {
                this.batchRequestContent = new BatchRequestContent();
                this.batchSize = 0L;
                this.requestPerId = new HashMap<String, CallStructure>();
            }
            String requestId = null;
            if (this.batchSize >= this.maxBatchSize) {
                this.flushListRowsAndRetry();
            }
            requestId = listItem == null ? this.batchRequestContent.addBatchRequestStep(listItemRequest, method) : this.batchRequestContent.addBatchRequestStep(listItemRequest, method, (Object)listItem);
            this.requestPerId.put(requestId, new CallStructure<IHttpRequest, HttpMethod, ListItem>(listItemRequest, method, listItem));
            ++this.batchSize;
        }

        public void flushBatch() throws InterruptedException {
            BatchResponseContent batchResponse = this.graphClient.batch().buildRequest(new Option[0]).post(this.batchRequestContent);
            java.util.List responses = batchResponse.responses;
            BatchRequestContent nextBatchRequestContent = new BatchRequestContent();
            long errors = 0L;
            long errors429 = 0L;
            long successes = 0L;
            int delaySecs = 5;
            for (BatchResponseStep response : responses) {
                if (response.status >= 400) {
                    ++errors;
                    if (response.status == 429 || response.status == 400) {
                        int retryAfter;
                        ++errors429;
                        callStructure = this.requestPerId.get(response.id);
                        HttpMethod method = (HttpMethod)callStructure.getMethod();
                        Object listItem = callStructure.getListItem();
                        String newAttemptId = null;
                        newAttemptId = listItem == null ? nextBatchRequestContent.addBatchRequestStep((IHttpRequest)callStructure.getRequest(), method) : nextBatchRequestContent.addBatchRequestStep((IHttpRequest)callStructure.getRequest(), method, listItem);
                        logger.warn((Object)("Error " + response.status + ", pushing request " + response.id + " in batch list as id " + newAttemptId));
                        this.requestPerId.put(newAttemptId, this.requestPerId.get(response.id));
                        if (response.headers.containsKey("Retry-After") && (retryAfter = Integer.parseInt((String)response.headers.get("Retry-After"))) > delaySecs) {
                            delaySecs = retryAfter;
                        }
                    } else {
                        logger.error((Object)("Error " + response.status + " on batch operation id " + response.id + " body=" + String.valueOf(response.body)));
                        callStructure = this.requestPerId.get(response.id);
                        logger.error((Object)("Failed on request: " + String.valueOf(callStructure.getRequest()) + " method: " + String.valueOf(callStructure.getMethod()) + " list item: " + callStructure.getListItem().toString()));
                    }
                } else {
                    ++successes;
                }
                this.requestPerId.remove(response.id);
            }
            this.batchRequestContent = nextBatchRequestContent;
            this.batchSize = this.requestPerId.size();
            if (this.batchSize > 0L) {
                logger.info((Object)("Remaining size batch for next loop: " + this.batchSize));
            }
            if (errors > 0L || errors429 > 0L) {
                logger.info((Object)(errors + " errors, " + errors429 + " e429, " + successes + " successes"));
            }
            if (errors429 > 0L) {
                logger.warn((Object)String.format("Sleeping for %d seconds", delaySecs));
                Thread.sleep((long)delaySecs * 1000L);
            }
        }

        public String deleteList(String siteId, String listId) throws Exception {
            String previousListName = null;
            try {
                List list = this.graphClient.sites(siteId).lists(listId).buildRequest(new Option[0]).get();
                previousListName = list.displayName;
                logger.info((Object)("Previous list name: " + previousListName + "(id:" + listId + ")"));
                list = this.graphClient.sites(siteId).lists(listId).buildRequest(new Option[0]).delete();
            }
            catch (Exception e) {
                logger.error((Object)("Could not delete list " + listId + " on site " + siteId + " :" + ExceptionUtils.getMessageWithCauses((Throwable)e)), (Throwable)e);
            }
            return previousListName;
        }

        public String createList(String siteId, String listName) throws Exception {
            logger.info((Object)("Creating list " + listName + " on site " + siteId));
            List list = new List();
            list.displayName = listName;
            ListInfo listInfo = new ListInfo();
            listInfo.template = "genericList";
            list.list = listInfo;
            List newList = null;
            newList = ((ListCollectionRequest)this.graphClient.sites(siteId).lists().buildRequest(new Option[0])).post(list);
            if (newList != null) {
                return newList.id;
            }
            return null;
        }

        public String recreateList(String siteId, String listId) throws Exception {
            logger.info((Object)("Deleting and recreating list " + listId + " on site " + siteId));
            String previousListName = null;
            String newListId = null;
            previousListName = this.deleteList(siteId, listId);
            newListId = this.createList(siteId, previousListName);
            logger.info((Object)("New list id is " + newListId + " on site " + siteId));
            return newListId;
        }

        public void deleteAllRows(String siteId, String listId) throws Exception {
            logger.info((Object)("Deleting all elements for list " + listId + " on site " + siteId));
            LinkedList<QueryOption> requestOptions = new LinkedList<QueryOption>();
            requestOptions.add(new QueryOption("expand", (Object)"field"));
            ListItemCollectionPage listPage = (ListItemCollectionPage)((ListItemCollectionRequest)this.graphClient.sites(siteId).lists(listId).items().buildRequest(requestOptions)).get();
            java.util.List listRows = listPage.getCurrentPage();
            while (listPage != null) {
                for (ListItem listRow : listRows) {
                    String rowId = listRow.id;
                    ListItemRequest rowItemRequest = this.graphClient.sites(siteId).lists(listId).items(rowId).buildRequest(new Option[0]);
                    this.addItemToBatch((IHttpRequest)rowItemRequest, HttpMethod.DELETE, null);
                }
                ListItemCollectionRequestBuilder nextPage = (ListItemCollectionRequestBuilder)listPage.getNextPage();
                if (nextPage == null) break;
                logger.info((Object)"Getting next page of rows to delete");
                listPage = (ListItemCollectionPage)((ListItemCollectionRequest)nextPage.buildRequest(new Option[0])).get();
                listRows = listPage.getCurrentPage();
            }
            if (this.batchSize > 0L) {
                this.flushListRowsAndRetry();
            }
            if (this.batchSize == 0L) {
                logger.info((Object)"All rows deleted");
            } else {
                logger.error((Object)("Could not delete " + this.batchSize + " rows from the list"));
            }
        }

        public DriveItem getItem(String itemSite, String itemDrive, String itemPath) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)itemSite), (Object)"The site ID is not set");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)itemDrive), (Object)"The drive ID is not set");
            logger.info((Object)("Getting item " + itemPath + "( " + itemSite + "/" + itemDrive + " )"));
            DriveItem driveItem = null;
            try {
                driveItem = this.graphClient.sites(itemSite).drives(itemDrive).root().itemWithPath(itemPath).buildRequest(new Option[0]).get();
            }
            catch (Exception e) {
                logger.error((Object)("Error while getting item " + itemPath + "( " + itemSite + "/" + itemDrive + " ): " + ExceptionUtils.getMessageWithCauses((Throwable)e)), (Throwable)e);
            }
            return driveItem;
        }

        public DriveItemCollectionPage getChildren(String siteId, String driveId, String normalizedRelativePath) throws IOException {
            logger.info((Object)("Getting children of  " + normalizedRelativePath + "( " + siteId + "/" + driveId + " )"));
            DriveItemCollectionPage children = null;
            try {
                children = (DriveItemCollectionPage)((DriveItemCollectionRequest)this.graphClient.sites(siteId).drives(driveId).root().itemWithPath(normalizedRelativePath).children().buildRequest(new Option[0])).get();
            }
            catch (Exception e) {
                throw new IOException("Error while getting children of  " + normalizedRelativePath + "( " + siteId + "/" + driveId + " ): " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            return children;
        }

        public InputStream getFileInputStream(String siteId, String driveId, String filePath) throws IOException {
            logger.info((Object)("Getting file input stream for " + filePath + " ( " + siteId + "/" + driveId + " )"));
            InputStream inputStream = null;
            try {
                inputStream = this.graphClient.sites(siteId).drives(driveId).root().itemWithPath(PathUtils.concatLNT((String[])new String[]{filePath})).content().buildRequest(new Option[0]).get();
            }
            catch (Exception e) {
                throw new IOException("Error while getting file input stream for " + filePath + " ( " + siteId + "/" + driveId + " ): " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            if (inputStream == null) {
                inputStream = InputStream.nullInputStream();
            }
            return inputStream;
        }

        public boolean checkInFile(String siteId, String driveId, String filePath) {
            logger.info((Object)("Checking in file " + filePath + " (" + siteId + "/" + driveId + ")"));
            try {
                this.graphClient.sites(siteId).drives(driveId).root().itemWithPath(filePath).checkin(DriveItemCheckinParameterSet.newBuilder().withCheckInAs(null).withComment("Generated with Dataiku").build()).buildRequest(new Option[0]).post();
            }
            catch (Exception e) {
                logger.error((Object)("Error while Checking in file " + filePath + " ( " + siteId + "/" + driveId + " )"), (Throwable)e);
                return false;
            }
            return true;
        }

        public OutputStream getOutputStream(final String siteId, final String driveId, final String filePath) throws IOException {
            return new OutputStream(){
                private final IProgressCallback uploadProgressLogger = new IProgressCallback(){
                    private long timeOfLastLog = 0L;

                    public void progress(long current, long max) {
                        boolean shouldLog;
                        long now = System.currentTimeMillis();
                        boolean bl = shouldLog = current == max || now - this.timeOfLastLog > 5000L;
                        if (shouldLog) {
                            this.timeOfLastLog = now;
                            logger.debugV("Uploaded %s bytes out of %s to sharepoint for file at %s", new Object[]{current, max, filePath});
                        }
                    }
                };
                private static final int UPLOAD_CHUNK_SIZE = 0x500000;
                private static final byte[] EMPTY_BYTES = new byte[0];
                private final AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"sharepoint-upload-cache", (String)"cached_upload_file_", (String)"tmp");
                private final OutputStream bufferOutputStream = new BufferedOutputStream(new FileOutputStream((File)this.tmpFile), 262144);
                private boolean isAlreadyClosed = false;

                @Override
                public synchronized void write(int b) throws IOException {
                    if (this.isAlreadyClosed) {
                        throw new IOException("Cannot write into an SharePoint Stream that has been closed.");
                    }
                    try {
                        this.bufferOutputStream.write(b);
                    }
                    catch (IOException e) {
                        throw new IOException("Problem writing to buffer for sharepoint upload: " + ExceptionUtils.getMessageWithCauses((Throwable)e), e);
                    }
                }

                @Override
                public synchronized void write(byte[] b, int off, int len) throws IOException {
                    if (this.isAlreadyClosed) {
                        throw new IOException("Cannot write into an SharePoint Stream that has been closed.");
                    }
                    if (b == null) {
                        throw new NullPointerException();
                    }
                    if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    try {
                        this.bufferOutputStream.write(b, off, len);
                    }
                    catch (IOException e) {
                        logger.errorV((Throwable)e, "Error writing to pre-upload buffer for sharepoint upload of %s (%s / %s). Error messages: %s", new Object[]{filePath, driveId, siteId, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                        throw new IOException("Problem writing to pre-upload buffer for sharepoint upload: " + ExceptionUtils.getMessageWithCauses((Throwable)e), e);
                    }
                }

                @Override
                public synchronized void flush() throws IOException {
                    if (this.isAlreadyClosed) {
                        throw new IOException("Cannot flush an SharePoint Stream that has been closed.");
                    }
                    try {
                        this.bufferOutputStream.flush();
                    }
                    catch (IOException e) {
                        logger.errorV((Throwable)e, "Error flushing to pre-upload buffer for sharepoint upload of %s (%s / %s). Error messages: %s", new Object[]{filePath, driveId, siteId, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                        throw new IOException("Problem flushing pre-upload buffer for sharepoint upload: " + ExceptionUtils.getMessageWithCauses((Throwable)e), e);
                    }
                    logger.debugV("Flush called. Sharepoint file data has been flushed to the databuffer, not yet sent to sharepoint. Current buffer size = %s bytes", new Object[]{this.tmpFile.length()});
                }

                private void putEmptyFileToDrive() throws IOException {
                    logger.infoV("Sending an empty file under path: %s, to driveId: %s and siteId: %s.", new Object[]{filePath, driveId, siteId});
                    try {
                        SharePointOnlineClient.this.graphClient.sites(siteId).drives(driveId).root().itemWithPath(filePath).content().buildRequest(new Option[0]).put(EMPTY_BYTES);
                    }
                    catch (Exception e) {
                        logger.errorV((Throwable)e, "Error while putting empty file under path: %s, to driveId: %s and siteId: %s.", new Object[]{filePath, driveId, siteId});
                        throw new IOException(String.format("Error while putting empty file under path: %s.", filePath), e);
                    }
                }

                private void flushBufferToDrive() throws IOException {
                    try {
                        try {
                            this.bufferOutputStream.flush();
                        }
                        finally {
                            this.bufferOutputStream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new IOException("Problem flushing or closing buffer for sharepoint upload", e);
                    }
                    long fileSizeBytes = this.tmpFile.length();
                    if (fileSizeBytes == 0L) {
                        this.putEmptyFileToDrive();
                    } else {
                        DriveItemCreateUploadSessionParameterSet uploadParams = DriveItemCreateUploadSessionParameterSet.newBuilder().withItem(new DriveItemUploadableProperties()).build();
                        UploadSession uploadSession = SharePointOnlineClient.this.graphClient.sites(siteId).drives(driveId).root().itemWithPath(filePath).createUploadSession(uploadParams).buildRequest(new Option[0]).post();
                        logger.infoV("Sending sharepoint file: %s (%s / %s).", new Object[]{filePath, driveId, siteId});
                        if (logger.isInfoEnabled()) {
                            String sanitizeUrl = UrlRedactionUtils.sanitizeUrlParams((String)uploadSession.getUploadUrl(), Map.of("tempauth", "*****"));
                            logger.infoV("Sending to %s", new Object[]{sanitizeUrl});
                            logger.infoV("Sending size = %s", new Object[]{fileSizeBytes});
                        }
                        try (BufferedInputStream bufferInputStream = new BufferedInputStream(new FileInputStream((File)this.tmpFile), 0x500000);){
                            LargeFileUploadTask largeFileUploadTask = new LargeFileUploadTask((IUploadSession)uploadSession, SharePointOnlineClient.this.graphClient, (InputStream)bufferInputStream, fileSizeBytes, DriveItem.class);
                            LargeFileUploadResult response = largeFileUploadTask.upload(0x500000, null, this.uploadProgressLogger);
                            String uploadedNameString = ((DriveItem)response.responseBody).name != null ? ((DriveItem)response.responseBody).name : "unknown";
                            String sizeString = ((DriveItem)response.responseBody).size != null ? ((DriveItem)response.responseBody).size.toString() : "unknown";
                            logger.infoV("Sharepoint upload succeeded of file %s (%s / %s).", new Object[]{filePath, driveId, siteId});
                            logger.infoV("Uploaded to name: %s, uploaded size: %s", new Object[]{uploadedNameString, sizeString});
                        }
                        catch (Exception e) {
                            logger.errorV((Throwable)e, "Error while uploading to sharepoint file %s (%s / %s). Error messages: %s ", new Object[]{filePath, driveId, siteId, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                            throw new IOException("Error while uploading to sharepoint: " + ExceptionUtils.getMessageWithCauses((Throwable)e), e);
                        }
                    }
                }

                @Override
                public synchronized void close() throws IOException {
                    logger.info((Object)"Close called on sharepoint output stream (should start the upload from the buffer)");
                    if (this.isAlreadyClosed) {
                        logger.warn((Object)"The output stream has already been closed");
                        return;
                    }
                    this.isAlreadyClosed = true;
                    try {
                        this.flushBufferToDrive();
                        SharePointOnlineClient.this.checkInFile(siteId, driveId, filePath);
                    }
                    finally {
                        this.tmpFile.close();
                    }
                }
            };
        }

        public boolean deleteFile(String siteId, String driveId, String normalizedRelativePath) throws DKUSecurityException {
            logger.info((Object)("Deleting file " + siteId + ":" + driveId + ":" + normalizedRelativePath));
            PathUtils.ensurePathStaysWithinRoot((String)normalizedRelativePath);
            DriveItem driveItem = this.graphClient.sites(siteId).drives(driveId).root().itemWithPath(normalizedRelativePath).buildRequest(new Option[0]).delete();
            return driveItem != null;
        }

        public boolean moveFile(String siteId, String driveId, String fromId, String toId, String filename) {
            logger.info((Object)("Moving file on site:" + siteId + " drive:" + driveId + " from id:" + fromId + " to id:" + toId + " (" + filename + ")"));
            DriveItemCopyParameterSet itemRequestBuilder = new DriveItemCopyParameterSet();
            itemRequestBuilder.parentReference = new ItemReference();
            itemRequestBuilder.parentReference.id = toId;
            itemRequestBuilder.name = filename;
            DriveItem renamedItem = new DriveItem();
            renamedItem.parentReference = new ItemReference();
            renamedItem.parentReference.id = toId;
            renamedItem.name = filename;
            DriveItem driveItem = this.graphClient.sites(siteId).drives(driveId).items(fromId).buildRequest(new Option[0]).patch(renamedItem);
            return driveItem != null;
        }

        public java.util.List<BatchResponseContent> getPermissionForFiles(String siteId, String driveId, SharePointOnlineFSProvider provider, java.util.List<String> relativeItemPaths, Map<String, String> requestIdToFilePathMap) {
            if (relativeItemPaths.isEmpty()) {
                return java.util.List.of();
            }
            logger.info((Object)"Retrieving permissions for files");
            ArrayList<BatchResponseContent> responses = new ArrayList<BatchResponseContent>();
            BatchRequestContent batchRequest = new BatchRequestContent();
            int batchLen = 0;
            try {
                for (String relativeItemPath : relativeItemPaths) {
                    if ((long)batchLen >= this.maxBatchSize) {
                        responses.add(this.graphClient.batch().buildRequest(new Option[0]).post(batchRequest));
                        batchRequest = new BatchRequestContent();
                        batchLen = 0;
                    }
                    PermissionCollectionRequest permissionCollectionRequest = (PermissionCollectionRequest)this.graphClient.sites(siteId).drives(driveId).root().itemWithPath(PathUtils.concatLNT((String[])new String[]{provider.getRoot(), relativeItemPath})).permissions().buildRequest(new Option[0]);
                    String requestId = batchRequest.addBatchRequestStep((IHttpRequest)permissionCollectionRequest, HttpMethod.GET);
                    requestIdToFilePathMap.put(requestId, relativeItemPath);
                    ++batchLen;
                }
                if (batchRequest.requests != null && !batchRequest.requests.isEmpty()) {
                    responses.add(this.graphClient.batch().buildRequest(new Option[0]).post(batchRequest));
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error while retrieving file permissions.", (Throwable)e);
                throw e;
            }
            return responses;
        }

        public java.util.List<BatchResponseContent> getGroups(Set<String> entraGroupIds, Map<String, String> requestIdToGroupDetailsMap) {
            if (entraGroupIds.isEmpty()) {
                return java.util.List.of();
            }
            logger.info((Object)"Retrieving group details");
            ArrayList<BatchResponseContent> responses = new ArrayList<BatchResponseContent>();
            BatchRequestContent batchRequest = new BatchRequestContent();
            int batchLen = 0;
            try {
                for (String entraGroupId : entraGroupIds) {
                    if ((long)batchLen >= this.maxBatchSize) {
                        responses.add(this.graphClient.batch().buildRequest(new Option[0]).post(batchRequest));
                        batchRequest = new BatchRequestContent();
                        batchLen = 0;
                    }
                    GroupRequest groupRequest = this.graphClient.groups(entraGroupId).buildRequest(new Option[0]);
                    String requestId = batchRequest.addBatchRequestStep((IHttpRequest)groupRequest, HttpMethod.GET);
                    requestIdToGroupDetailsMap.put(requestId, entraGroupId);
                    ++batchLen;
                }
                if (batchRequest.requests != null && !batchRequest.requests.isEmpty()) {
                    responses.add(this.graphClient.batch().buildRequest(new Option[0]).post(batchRequest));
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error while retrieving group details.", (Throwable)e);
                throw e;
            }
            return responses;
        }

        public class CustomSite {
            public String id;
            public String name;
        }

        public class CustomDrive {
            public String id;
            public String name;
        }

        public class CustomList {
            public String id;
            public String name;
            public String displayName;
        }

        public class CallStructure<IHttpRequest, HttpMethod, ListItem> {
            private final IHttpRequest request;
            private final HttpMethod method;
            private final ListItem listItem;

            public CallStructure(IHttpRequest request, HttpMethod method, ListItem listItem) {
                this.request = request;
                this.method = method;
                this.listItem = listItem;
            }

            public IHttpRequest getRequest() {
                return this.request;
            }

            public HttpMethod getMethod() {
                return this.method;
            }

            public ListItem getListItem() {
                return this.listItem;
            }
        }
    }

    public static class SerializableSharePointCredentials
    implements ICredentialsService.BasicCredentialConvertible {
        public AuthType authType;
        public String oauth2AppId;
        public String oauth2AppSecret;
        public String oauth2AuthorizationEndpoint;
        public String oauth2TokenEndpoint;
        public String oauth2Scope;
        public String oauth2RefreshToken;
        public String oauth2AccessToken;
        public String user;
        public String password;
        public String privateKey;
        public String thumbprint;

        @Override
        public ICredentialsService.BasicCredential toBasicCredential() {
            return new ICredentialsService.BasicCredential(this.user, this.password);
        }
    }
}

