/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dip.connections.bigquery.builtin.BigQueryDataType;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.LegacySQLTypeName;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Schema;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class BigQueryResultSetMetadata
implements ResultSetMetaData {
    private final Schema schema;

    public BigQueryResultSetMetadata(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public int getColumnCount() {
        return this.schema.getFields().size();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        Field.Mode mode = this.getColumnAtIndex(column).getMode();
        if (mode == null) {
            return 1;
        }
        return switch (mode) {
            case Field.Mode.NULLABLE -> 1;
            case Field.Mode.REQUIRED -> 0;
            default -> 2;
        };
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        LegacySQLTypeName type = this.getColumnAtIndex(column).getType();
        return BigQueryDataType.fromType((LegacySQLTypeName)type).displaySize;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        LegacySQLTypeName type = this.getColumnAtIndex(column).getType();
        return BigQueryDataType.fromType((LegacySQLTypeName)type).precision;
    }

    @Override
    public int getScale(int column) throws SQLException {
        LegacySQLTypeName type = this.getColumnAtIndex(column).getType();
        return BigQueryDataType.fromType((LegacySQLTypeName)type).decimalDigits;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnAtIndex(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnAtIndex(column).getName();
    }

    @Override
    public String getSchemaName(int column) {
        return "";
    }

    @Override
    public String getTableName(int column) {
        return "";
    }

    @Override
    public String getCatalogName(int column) {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        Field field = this.getColumnAtIndex(column);
        if (field.getMode() == Field.Mode.REPEATED) {
            return 2003;
        }
        return BigQueryDataType.fromType((LegacySQLTypeName)field.getType()).sqlType;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumnAtIndex(column).getType().getStandardType().name();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    private Field getColumnAtIndex(int column) throws SQLException {
        try {
            return this.schema.getFields().get(column - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("Invalid column index: " + column, e);
        }
    }
}

