/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ECRUtils {
    public static String getRegionFromRepositoryURL(String repositoryURL) {
        Matcher repositoryHostMatcher;
        URI repositoryURI;
        try {
            while (((String)repositoryURL).startsWith("/")) {
                repositoryURL = ((String)repositoryURL).substring(1);
            }
            repositoryURI = new URI((String)repositoryURL);
            if (StringUtils.isBlank((String)repositoryURI.getScheme())) {
                repositoryURL = "ecr://" + (String)repositoryURL;
                repositoryURI = new URI((String)repositoryURL);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Repository url is not valid", e);
        }
        Pattern repositoryHostPattern = Pattern.compile("[^.]+\\.dkr\\.ecr\\.([^.]+)\\.amazonaws\\.com");
        String host = repositoryURI.getHost();
        if (host != null && (repositoryHostMatcher = repositoryHostPattern.matcher(host)).matches()) {
            return repositoryHostMatcher.group(1);
        }
        throw new IllegalArgumentException("Could not infer EKS region from repository URL: " + (String)repositoryURL);
    }
}

