/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotedModality;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PivotElementSQLGenerator {
    public static final String COUNT_COLUMN_NAME = "_DKU_value_count";
    private final Schema schema;
    private final PivotElement pivotElement;

    public PivotElementSQLGenerator(PivotElement pivotElement, Schema schema) {
        this.pivotElement = pivotElement;
        this.schema = schema;
    }

    public SelectQueryBuilder generateValueCollectionQuery(SQLUtils.SQLTable sqlTable, SelectQueryBuilder query) {
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        SelectQueryBuilder qb = new SelectQueryBuilder();
        for (String key : this.pivotElement.keyColumns) {
            ExpressionBuilder col = ef.col(key);
            qb.select(col, key);
            qb.group(col);
        }
        qb.select(ef.col("*").count(), COUNT_COLUMN_NAME);
        if (sqlTable != null) {
            qb.from(sqlTable, "__value_counts__");
        } else {
            qb.from(query, "__value_counts__");
        }
        if (this.pivotElement.valueLimit == PivotElement.PivotValueLimit.TOP_N) {
            SelectQueryBuilder orderQB = new SelectQueryBuilder();
            for (String key : this.pivotElement.keyColumns) {
                orderQB.select(ef.col(key), key);
            }
            orderQB.select(ef.col(COUNT_COLUMN_NAME), COUNT_COLUMN_NAME);
            orderQB.from(qb, "__ordering_subquery__");
            orderQB.order(ef.col(COUNT_COLUMN_NAME), QueryAst.OrderType.DESC);
            orderQB.limit(Long.valueOf(this.pivotElement.topnLimit));
            qb = orderQB;
        } else if (this.pivotElement.valueLimit == PivotElement.PivotValueLimit.AT_LEAST_N_OCC) {
            SelectQueryBuilder filteringQB = new SelectQueryBuilder();
            for (String key : this.pivotElement.keyColumns) {
                filteringQB.select(ef.col(key), key);
            }
            filteringQB.select(ef.col(COUNT_COLUMN_NAME), COUNT_COLUMN_NAME);
            filteringQB.from(qb, "__filtering_subquery__");
            filteringQB.where(ef.col(COUNT_COLUMN_NAME).gte(this.pivotElement.minOccLimit));
            qb = filteringQB;
        }
        return qb;
    }

    public void generatePivotedQuery(List<PivotedModality> modalities, SelectQueryBuilder qb, SQLDialect dialect) {
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        for (PivotedModality modality : modalities) {
            ArrayList conditions = Lists.newArrayList();
            for (int i = 0; i < this.pivotElement.keyColumns.size(); ++i) {
                String key = this.pivotElement.keyColumns.get(i);
                String value = modality.keyValues.get(i);
                ExpressionBuilder col = ef.col(key);
                Type type = this.schema.getColumn(key).getType();
                conditions.add(ExpressionUtils.getEqualityTest(col, value, type));
            }
            ExpressionBuilder test = ef.and(conditions.toArray(new ExpressionBuilder[0]));
            for (PivotedModality.PivotedColumn valueColumn : modality.valueColumns) {
                String value = valueColumn.source;
                String output = valueColumn.pivoted;
                ExpressionBuilder col = ef.col(value);
                ExpressionBuilder filtered = ef.caseWhen(test, col);
                qb.select(filtered, output);
            }
            if (!StringUtils.isNotBlank((String)modality.globalCountColumn)) continue;
            ExpressionBuilder counted = ef.caseWhen(test, ef.cst(1), ef.cst(null));
            qb.select(counted, modality.globalCountColumn);
        }
    }
}

