/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.utils;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.utils.SingleCallAsserter;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class OutputStreamFormattingProcessorOutput
implements ProcessorOutput {
    private ColumnFactory cf;
    private OutputStream os;
    private OutputFormatter formatter;
    private boolean headerEmitted;
    private SingleCallAsserter lre = new SingleCallAsserter();
    private static Logger logger = Logger.getLogger((String)"dku.datalayer");

    public OutputStreamFormattingProcessorOutput(OutputStream os, OutputFormatter formatter, ColumnFactory cf) {
        this.os = os;
        this.formatter = formatter;
        this.cf = cf;
    }

    public void emitRow(Row row) throws Exception {
        if (!this.headerEmitted) {
            this.headerEmitted = true;
            this.formatter.header(this.cf, this.os);
        }
        this.formatter.format(row, this.cf, this.os);
    }

    public void lastRowEmitted() throws Exception {
        this.lre.call("processor closed");
        this.formatter.footer(this.cf, this.os);
        this.os.close();
    }

    public void cancel() throws Exception {
        this.formatter.cancel(this.os);
        this.os.close();
    }

    public void setMaxMemoryUsed(long size) {
    }
}

